#include "stdafx.h"
#include "..\scpl/List.h"
#include "..\scpl/DList.h"
#include <stdlib.h>
#include "testClass.h"

using namespace scpl;
typedef List<LCLS> LL;
typedef DList<unsigned long> DUL;

void test_List(){
	{
		LCLS lcls[9];

		LL a;
		SUT_ASSERT_EQUALS(Int,a.empty(),true);
		SUT_ASSERT_EQUALS(Int,a.capacity(),0);
		SUT_ASSERT_EQUALS(Int,a.count(),0);

		LL b(10);
		SUT_ASSERT_EQUALS(Int,b.empty(),true);
		SUT_ASSERT_EQUALS(Int,b.capacity(),10);
		SUT_ASSERT_EQUALS(Int,b.count(),0);

		LL c(10);

		SUT_ASSERT_EQUALS(Int,ii,9);
		a.lastIn(lcls[0]);a.lastIn(lcls[1]);a.lastIn(lcls[2]);
		a.lastIn(lcls[3]);a.lastIn(lcls[4]);a.lastIn(lcls[5]);
		a.lastIn(lcls[6]);a.lastIn(lcls[7]);a.lastIn(lcls[8]);
		SUT_ASSERT_EQUALS(Int,ii,18);
		b.firstIn(lcls[0]);b.firstIn(lcls[1]);b.firstIn(lcls[2]);
		b.firstIn(lcls[3]);b.firstIn(lcls[4]);b.firstIn(lcls[5]);
		b.firstIn(lcls[6]);b.firstIn(lcls[7]);b.firstIn(lcls[8]);
		SUT_ASSERT_EQUALS(Int,ii,27);
		SUT_ASSERT_EQUALS(Int,a.empty(),false);
		SUT_ASSERT_EQUALS(Int,a.capacity(),9);
		SUT_ASSERT_EQUALS(Int,a.count(),9);
		SUT_ASSERT_EQUALS(Int,b.empty(),false);
		SUT_ASSERT_EQUALS(Int,b.capacity(),10);
		SUT_ASSERT_EQUALS(Int,b.count(),9);

		LL d(a);
		SUT_ASSERT_EQUALS(Int,d.empty(),false);
		SUT_ASSERT_EQUALS(Int,d.capacity(),9);
		SUT_ASSERT_EQUALS(Int,d.count(),9);

		LL e(b);
		SUT_ASSERT_EQUALS(Int,e.empty(),false);
		SUT_ASSERT_EQUALS(Int,e.capacity(),9);
		SUT_ASSERT_EQUALS(Int,e.count(),9);

		LL f;
		try{f.lastIn(c);SUT_ASSERT(Int,false);}
		catch(InvalidParamExc){}
		SUT_ASSERT_EQUALS(Int,f.empty(),true);
		SUT_ASSERT_EQUALS(Int,f.capacity(),0);
		SUT_ASSERT_EQUALS(Int,f.count(),0);

		SUT_ASSERT_EQUALS(Int,ii,27);

		SUT_ASSERT(Int,d == a);
		SUT_ASSERT(Int,e == b);
		SUT_ASSERT(Int,f == c);
		SUT_ASSERT(Int,a == a);
		SUT_ASSERT(Int,b != a);

		e = a;
		SUT_ASSERT_EQUALS(Int,e.empty(),false);
		SUT_ASSERT_EQUALS(Int,e.capacity(),9);
		SUT_ASSERT_EQUALS(Int,e.count(),9);
		d = f;
		SUT_ASSERT_EQUALS(Int,d.empty(),true);
		SUT_ASSERT_EQUALS(Int,d.capacity(),9);
		SUT_ASSERT_EQUALS(Int,d.count(),0);

		e.lastOut();
		SUT_ASSERT_EQUALS(Int,e.capacity(),9);
		SUT_ASSERT_EQUALS(Int,e.count(),8);
		e.firstOut();
		SUT_ASSERT_EQUALS(Int,e.capacity(),9);
		SUT_ASSERT_EQUALS(Int,e.count(),7);

		SUT_ASSERT_EQUALS(Int,ii,27);

		// access check
		{
			LL* x = &e;
			const LL* cx = &e;
			LCLS i;

			i = x->at(2);
			i = x->atFirst();
			i = x->atLast();

			i = cx->at(2);
			i = cx->atFirst();
			i = cx->atLast();
		}
	}
	SUT_ASSERT_EQUALS(Int,ii,0);
	{
		DUL a,b;
		SUT_ASSERT(Int,a.empty());
		SUT_ASSERT(Int,b.empty());
		for(unsigned long i=0;i<10;++i){
			a.lastIn(i);
			b.firstIn(i);
		}
		SUT_ASSERT(Int,!a.empty());
		SUT_ASSERT(Int,!b.empty());
		SUT_ASSERT_EQUALS(Int,a.count(),10);
		SUT_ASSERT_EQUALS(Int,b.count(),10);
		for(unsigned long i=0;i<10;++i){
			SUT_ASSERT_EQUALS(Int,a[i],b[9-i]);
		}
		DUL c(a),d(b);
		SUT_ASSERT(Int,!c.empty());
		SUT_ASSERT(Int,!d.empty());
		SUT_ASSERT(Int,a == c);
		SUT_ASSERT(Int,b == d);
		c.firstOut();
		d.lastOut();
		SUT_ASSERT_EQUALS(Int,c.count(),9);
		SUT_ASSERT_EQUALS(Int,d.count(),9);
		SUT_ASSERT_EQUALS(Int,c.capacity(),10);
		SUT_ASSERT_EQUALS(Int,d.capacity(),10);
		SUT_ASSERT_EQUALS(Int,c[0],1);
		SUT_ASSERT_EQUALS(Int,d[8],1);
		SUT_ASSERT(Int,a != c);
		SUT_ASSERT(Int,b != d);
		a = c;
		b.lastIn(d);
		SUT_ASSERT_EQUALS(Int,a.count(),9);
		SUT_ASSERT_EQUALS(Int,b.count(),19);
		a.clear(true);
		b.clear(false);
		SUT_ASSERT_EQUALS(Int,a.count(),0);
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,a.capacity(),0);
		SUT_ASSERT_EQUALS(Int,b.capacity(),19);
		SUT_ASSERT(Int,a.empty());
		SUT_ASSERT(Int,b.empty());

		// access check
		{
			DUL* x = &d;
			const DUL* cx = &d;
			unsigned long i;

			i = x->at(2);
			i = x->atFirst();
			i = x->atLast();

			i = cx->at(2);
			i = cx->atFirst();
			i = cx->atLast();
		}
	}
}
