// 
// DList.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _DList_INCLUDED_
#define _DList_INCLUDED_
#include "Buffer.h"
#include "smart_ptr.h"
#ifdef _MSC_VER
#include <string.h>
#else
#include <mem.h>
#endif

namespace scpl{

	/*
		f[^AzƂĎNXłB
		ListNXł̓NX̊Ǘ̂߁Adeletenew̏܂A
		̃NXł̓f[^̊Ǘ݂̂̏Ȃ̂œ삪ɂȂ܂B

		̃NXł͊ǗNXdelete邢̓RXgN^
		sȂ̂ŒӂĂB
	*/

	template <class T>
	class DList{
	public:
		typedef T*			ptr;
		typedef const T*	cptr;
		typedef T&			ind;
		typedef const T&	cind;
	private:
		typedef Buffer<ptr>	buf;
		typedef DList<T>	self;

		Buffer<T>	_Data;
		ulong		_UseCount;

	public:
		/* ̃XgA邢͎w肵TCYmۂč쐬܂B */
		DList(ulong c=0)throw(OutOfMemExc):_Data(c,true),_UseCount(0){}

		/* Xg̕𐶐܂B */
		DList(const self& s)throw(OutOfMemExc):_UseCount(0){lastIn(s);}

		virtual ~DList(){clear();}

		/* f[^݂邩Ԃ܂B*/
		operator bool()const{return !empty();}
		/* f[^݂ȂԂ܂B*/
		bool operator!()const{return empty();}
		/* f[^݂ȂԂ܂B*/
		bool empty()const{return _UseCount == 0;}
		/* ڐԂ܂B */
		ulong count()const{return _UseCount;}
		/* ݂̊i[\Ԃ܂B */
		ulong capacity()const{return _Data.count();}

		/* Xg܂B */
		self& operator=(const self& s)throw(OutOfMemExc){copy(s);return *this;}

		/* XgԂ܂B */
		bool operator==(const self& s)const{return equals(s);}
		/* XgłȂԂ܂B */
		bool operator!=(const self& s)const{return !equals(s);}

		/* w肵ʒuɂf[^Ԃ܂B */
		ind operator[](ulong index){return _Data.get()[index];}
		cind operator[](ulong index)const{return _Data.get()[index];}

		/* w肵ʒuɂf[^Ԃ܂B */
		ind at(ulong index)const throw(InvalidParamExc,InvalidCallExc){
			if(index < count()) return _Data.get()[index];
			if(empty()) throw InvalidCallExc();
			throw InvalidParamExc(1);
		}
		/* 擪̃f[^Ԃ܂B */
		ind atFirst()const throw(InvalidCallExc){return at(0);}
		/* Ō̃f[^Ԃ܂B */
		ind atLast()const throw(InvalidCallExc){return at(_UseCount-1);}

		/*
			p̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr begin()const{return _Data?_Data.get():NULL;}
		/*
			p̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr end()const{return _Data?(_Data.get()+_UseCount):NULL;}
		/*
			tp̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr rbegin()const{return _Data?(_Data.get()+_UseCount-1):NULL;}
		/*
			tp̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr rend()const{return _Data?(_Data.get()-1):NULL;}

		/*
			f[^w肵ʒuɑ}܂B
			data   - }f[^
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(cptr data,ulong index)throw(InvalidParamExc,OutOfMemExc){
			if(!data) throw InvalidParamExc(1);
			if(index > _UseCount) throw InvalidParamExc(1);
			if(_UseCount+1 > capacity()) _Data.aResize(_UseCount+1,true);
			ptr pos = _Data.get() + index;
			if(index != _UseCount){
				memmove(pos + 1,pos,(_UseCount - index) * sizeof(T));
			}
			*pos = *data;
			++_UseCount;
			return index;
		}
		/*
			f[^w肵ʒuɕđ}܂B
			t      - }f[^
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(T t,ulong index)throw(InvalidParamExc,OutOfMemExc){return insert(&t,index);}
		/*
			Xgw肵ʒuɑ}܂B
			s      - }郊Xg
			index  - }ʒuB{0 <= index <= count()} ܂ł͈̔́B
			߂l - }ꂽʒuB
 		*/
		ulong insert(const self& s,ulong index)throw(InvalidParamExc,OutOfMemExc){
			if(!s) throw InvalidParamExc(1);
			if(index > _UseCount) throw InvalidParamExc(1);
			ulong z = s.count();
			if(_UseCount+z > capacity()) _Data.aResize(_UseCount+z,true);
			ptr pos = _Data.get() + index;
			if(index != _UseCount){
				memmove(pos + z,pos,(_UseCount - index) * sizeof(T));
			}
			memcpy(pos,s.begin(),z*sizeof(T));
			_UseCount+=z;
			return index;
		}

		/* f[^擪ɑ}܂B߂l͏0łB */
		ulong firstIn(cptr t)throw(InvalidParamExc,OutOfMemExc){return insert(t,0);}
		ulong firstIn(T t)throw(InvalidParamExc,OutOfMemExc){return insert(&t,0);}
		ulong firstIn(const self& s)throw(InvalidParamExc,OutOfMemExc){return insert(s,0);}

		/* f[^Ōɑ}܂B߂l͑}ꂽʒułB */
		ulong lastIn(ptr t)throw(InvalidParamExc,OutOfMemExc){return insert(t,count());}
		ulong lastIn(T t)throw(InvalidParamExc,OutOfMemExc){return insert(&t,count());}
		ulong lastIn(const self& s)throw(InvalidParamExc,OutOfMemExc){return insert(s,count());}

		/*
			w肵ʒuɂf[^폜܂B
			index  - 폜f[^ւ̈ʒuB{0 <= index < count()} ܂ł͈̔́B
		*/
		void removeAt(ulong index)throw(InvalidParamExc,InvalidCallExc){
			if(_UseCount == 0) throw InvalidCallExc();
			if(index >= _UseCount) throw InvalidParamExc(1);
			ptr pos = _Data.get() + index;
			if(index != _UseCount - 1){
				memmove(pos,pos + 1,(_UseCount - index) * sizeof(T));
			}
			--_UseCount;
		}
		/*
			w肵|C^ʒuɂf[^폜܂B
			R|C^̓obt@̒łKv܂B
		*/
		void remove(cptr index)throw(InvalidParamExc,InvalidCallExc){removeAt(toPos(index));}

		/* 擪̃f[^폜܂B */
		void firstOut()throw(InvalidCallExc){removeAt(0);}
		/* Ō̃f[^폜܂B */
		void lastOut()throw(InvalidCallExc){removeAt(_UseCount-1);}

		/*
			nꂽXg𕡐܂B
			Äɗ]肪oĂ̗͎̈c܂B
		*/
		void copy(const self& s)throw(OutOfMemExc){
			if(this != &s){
				clear(false);
				if(s) lastIn(s);
			}
		}

		/*
			zNA܂B
			capFree - Capacitÿ邩ǂBȗtrueB
		*/
		void clear(bool capFree=true){
			if(capFree) _Data.clear();
			_UseCount = 0;
		}

		/* Xgւ܂B */
		void swap(self& s){
			_Data.swap(s._Data);
			scpl::swap(_UseCount,s._UseCount);
		}

		/* w肵Xgƈv邩Ԃ܂B */
		bool equals(const self& s)const{
			return (this == &s)||((s.count() == count())&&(memcmp(_Data.get(),s._Data.get(),s.count()*sizeof(T))==0));
		}

		/* z̃|C^CfbNXlԂ܂B */
		ulong toPos(cptr* p)const throw(InvalidParamExc){
			if((_Data.get() > p)||(_Data.get()+_UseCount <= p)){
				throw InvalidParamExc(1);
			}
			return static_cast<ulong>(p - _Data.get());
		}

		/*
			mۂĂw肵܂B
			bufCount - mۂĂ
		*/
		void adjust(ulong bufCount=0){_Data.aResize(_UseCount+bufCount,true);}

		/*
			w肵ɏ܂B
			f[^0Ŗߐs܂B
		*/
		void init(ulong count)throw(OutOfMemExc){
			_Data.aResize(count,true);
		}

		/*
			w肵ɏ܂B
			i[f[^͎w肵f[^̃Rs[łB
		*/
		void init(ulong count,cind t)throw(OutOfMemExc){
			_Data.aResize(count);
			for(T *i=_Data.begin(),*n=_Data.end();i<n;++i) memcpy(i,&t,sizeof(T));
		}

	};

} // namespace scpl
#endif