// 
// Chain.h
// 
// Copyright(C) 2007 Ó
#ifndef _Chain_INCLUDED_
#define _Chain_INCLUDED_
#include "smart_ptr.h"

namespace scpl{

	/*
		zz(Oobt@)̌ЂƂȂev[gNXB
		̃NX̓|C^NXgăf[^Ǘ܂B
		ev[gɂ͊i[f[^yуNXw肵܂B
		̃NX𑼂̓^̃NXƂȂ邱Ƃɂ荽̂悤ɂȂ܂B
		f[^ւ̃ANZX́A|C^NXƂقړłB
		ev[g2Ԗڂɂ̓ftHgłsmart_ptrłAɂ
		managed_ptrw肷邱Ƃł܂B
	*/

	template<class T,class Ptr=smart_ptr<T> >
	class Chain{
		typedef Chain<T,Ptr> self;
		typedef T* ptr;
		typedef const T* cptr;
		typedef Ptr sptr;
		typedef const Ptr csptr;

	public:
		Chain(){_Next = _Prev = this;}
		Chain(const sptr& ptr):_Data(ptr){_Next = _Prev = this;}

		/* VЂƂăCX^X𕡐܂B */
		Chain(const self& s):_Data(s){_Next = _Prev = this;}
		self& operator=(const self& s){
			escape();
			_Data = s;
		}

		virtual ~Chain(){escape();}

		/* f[^Ԃ܂B */
		operator sptr&(){return _Data;}
		operator const sptr&()const{return _Data;}

		/* f[^̎QƂԂ܂B */
		T& operator*(){return *_Data;}
		const T& operator*()const{return *_Data;}

		/* f[^փANZX܂B */
		T* operator->()const{return _Data;}

		/* f[^Ԃ܂B */
		sptr& get(){return _Data;}
		csptr& get()const{return _Data;}

		/* f[^ւ̃|C^Ԃ܂B */
		ptr getPtr(){return _Data;}
		cptr getPtr()const{return _Data;}

		/* zz񂩂O܂B */
		void escape(){
			_Next->_Prev = _Prev;
			_Prev->_Next = _Next;
			_Prev = _Next = this;
		}

		/*
			w肵Ђ̃NX̎̈ʒuɂȂ܂B
			ЂȂĂꍇ͂܂Ƃ߂ĂȂ܂B
			߂l : łꍇtrueAsꍇfalseԂ܂B
			         sꍇƂ́Aw肵ЂgłꍇłB
		*/
		bool insertToNext(self* s){
			if(s == this) return false;
			if(s->_Prev != s){
				s->_Prev->_Next = _Next;
				_Next->_Prev = s->_Prev;
				s->_Prev = this;
				_Next = s;
			}
			else{
				s->_Prev = this;
				s->_Next = _Next;
				_Next->_Prev = s;
				_Next = s;
			}
			return true;
		}

		/*
			w肵Ђ̃NX̑ÖʒuɂȂ܂B
			ЂȂĂꍇ͂܂Ƃ߂ĂȂ܂B
			߂l : łꍇtrueAsꍇfalseԂ܂B
			         sꍇƂ́Aw肵ЂgłꍇłB
		*/
		bool insertToPrev(self* s){
			if(s == this) return false;
			if(s->_Prev != s){
				s->_Prev->_Next = this;
				_Prev->_Next = s;
				s->_Prev = _Prev;
				_Prev = s->_Prev;
			}
			else{
				s->_Next = this;
				s->_Prev = _Prev;
				_Prev->_Next = s;
				_Prev = s;
			}
			return true;
		}

		/* ̈ʒũ|C^Ԃ܂B */
		self* next(){return _Next;}
		const self* next()const{return _Next;}

		/* Öʒũ|C^Ԃ܂B */
		self* prev(){return _Prev;}
		const self* prev()const{return _Prev;}

		/* w肵ЂƂɂȂĂSĂ̌Ђ delete ܂B */
		static void deleteAll(self* s){
			if(s){
				self* i = s;
				self* d;
				bool b;
				do{
					d = i;
					i = i->next();
					b = (d != i);
					delete d;
				}while(b);
			}
		}

	private:
		self* _Next;
		self* _Prev;
		sptr _Data;

	};

	/*
		zz(Oobt@)̌ЂƂȂev[gNXB
		̃NX͎w肵ev[g^܂B
	*/

	template<class T>
	class DChain{
		typedef DChain<T>	self;

	public:
		DChain(){_Next = _Prev = this;}
		DChain(const T& t):_Data(t){_Next = _Prev = this;}

		/* VЂƂăCX^X𕡐܂B */
		DChain(const self& s):_Data(s){_Next = _Prev = this;}
		self& operator=(const self& s){
			escape();
			_Data = s;
		}
		virtual ~DChain(){escape();}

		/* f[^Ԃ܂B */
		operator T&(){return _Data;}
		operator const T&()const{return _Data;}
		T& getIndirect(){return _Data;}
		const T& getIndirect()const{return _Data;}
		T* get()const{return &_Data;}

		/* f[^փANZX܂B */
		T* operator->()const{return &_Data;}

		/* zz񂩂O܂B */
		void escape(){
			_Next->_Prev = _Prev;
			_Prev->_Next = _Next;
			_Prev = _Next = this;
		}

		/*
			w肵Ђ̃NX̎̈ʒuɂȂ܂B
			ЂȂĂꍇ͂܂Ƃ߂ĂȂ܂B
			߂l : łꍇtrueAsꍇfalseԂ܂B
			         sꍇƂ́Aw肵ЂgłꍇłB
		*/
		bool insertToNext(self* s){
			if(s == this) return false;
			if(s->_Prev != s){
				s->_Prev->_Next = _Next;
				_Next->_Prev = s->_Prev;
				s->_Prev = this;
				_Next = s;
			}
			else{
				s->_Prev = this;
				s->_Next = _Next;
				_Next->_Prev = s;
				_Next = s;
			}
			return true;
		}

		/*
			w肵Ђ̃NX̑ÖʒuɂȂ܂B
			ЂȂĂꍇ͂܂Ƃ߂ĂȂ܂B
			߂l : łꍇtrueAsꍇfalseԂ܂B
			         sꍇƂ́Aw肵ЂgłꍇłB
		*/
		bool insertToPrev(self* s){
			if(s == this) return false;
			if(s->_Prev != s){
				s->_Prev->_Next = this;
				_Prev->_Next = s;
				s->_Prev = _Prev;
				_Prev = s->_Prev;
			}
			else{
				s->_Next = this;
				s->_Prev = _Prev;
				_Prev->_Next = s;
				_Prev = s;
			}
			return true;
		}

		/* ̈ʒũ|C^Ԃ܂B */
		self* next(){return _Next;}
		const self* next()const{return _Next;}

		/* Öʒũ|C^Ԃ܂B */
		self* prev(){return _Prev;}
		const self* prev()const{return _Prev;}

		/* w肵ЂƂɂȂĂSĂ̌Ђ delete ܂B */
		static void deleteAll(self* s){
			if(s){
				self* i = s;
				self* d;
				bool b;
				do{
					d = i;
					i = i->next();
					b = (d != i);
					delete d;
				}while(b);
			}
		}

	private:
		self* _Next;
		self* _Prev;
		T _Data;

	};

} // namespace scpl
#endif
