#include "stdafx.h"
#include "..\scpl/managed_ptr.h"

struct A{
	static int i;
	char c;
	A(char _c='A'):c(_c){++i;}
	virtual ~A(){--i;}
};
struct B:public A{
	B(char _c='B'):A(_c){}
};
struct C:public B{
	C(char _c='C'):B(_c){}
};

int A::i = 0;

using namespace scpl;
typedef managed_ptr<int> mi;
typedef managed_ptr<A> ma;
typedef managed_ptr<B> mb;
typedef managed_ptr<C> mc;

managed_delete(A){printf("delete[A](%c)\n",p->c);delete p;}
managed_delete(B){printf("delete[B](%c)\n",p->c);delete p;}
managed_delete(C){printf("delete[C](%c)\n",p->c);delete p;}

void test_managed_ptr(){
	{
		int *x = new int(0),*y = new int(10),*z = new int(100);
		mi a(x);
		mi b(a);
		mi c = a;
		SUT_ASSERT_EQUALS(Int,a.count(),3);
		SUT_ASSERT_EQUALS(Int,c.count(),3);
		{
			mi d(x);
			SUT_ASSERT_EQUALS(Int,c.count(),4);
			SUT_ASSERT_EQUALS(Int,d.count(),4);
		}
		SUT_ASSERT_EQUALS(Int,c.count(),3);
		b = (int*)NULL;
		SUT_ASSERT_EQUALS(Int,b.count(),0);
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		mi e(y);
		mi f = y;
		SUT_ASSERT_EQUALS(Int,f.count(),2);
		b = e;
		c = z;
		SUT_ASSERT_EQUALS(Int,b.count(),3);
		SUT_ASSERT_EQUALS(Int,c.count(),1);

		ma xa = new A;
		SUT_ASSERT_EQUALS(Int,A::i,1);
		mc _C(new C);
		mb _B = mb::cast(_C);
		ma _A = mb::cast(_B);
		SUT_ASSERT_EQUALS(Int,_A.count(),3);
		SUT_ASSERT_EQUALS(Int,_C.count(),3);
		SUT_ASSERT_EQUALS(Int,A::i,2);
		{
			mc _D = mc::cast(_A);
			SUT_ASSERT_EQUALS(Int,_C.count(),4);
			SUT_ASSERT_EQUALS(Int,_D.count(),4);
			SUT_ASSERT_EQUALS(Int,A::i,2);
		}
		SUT_ASSERT_EQUALS(Int,_C.count(),3);
		SUT_ASSERT_EQUALS(Int,A::i,2);
		_B = (B*)NULL;
		SUT_ASSERT_EQUALS(Int,_B.count(),0);
		SUT_ASSERT_EQUALS(Int,_A.count(),2);
		try{
			mc _E = mc::cast(xa);
			SUT_ASSERT(Int,false);
		}
		catch(std::bad_cast){}
		mb _F = _B;
		SUT_ASSERT_EQUALS(Int,_F.count(),0);
		_B = new B;
		SUT_ASSERT_EQUALS(Int,A::i,3);
		try{
			mb x(new B);
			_C = mc::cast(x);
			SUT_ASSERT(Int,false);
		}
		catch(std::bad_cast){}
		_A = ma::cast(_B);
		_C = (C*)NULL;
		SUT_ASSERT_EQUALS(Int,_B.count(),2);
		SUT_ASSERT_EQUALS(Int,_C.count(),0);
		SUT_ASSERT_EQUALS(Int,A::i,2);
		mc __C;
		_C.swap(__C);
	}
	SUT_ASSERT_EQUALS(Int,A::i,0);
}