#include "stdafx.h"
#include "..\scpl/Map.h"
#include "..\scpl/String.h"
#include "..\scpl/frag.h"
#include <stdlib.h>
#include "testClass.h"

using namespace scpl;
typedef Map<int,LCLS> ILMap;
typedef Map<AString,LCLS> SLMap;
typedef smart_ptr<LCLS> sl;

void test_Map(){
	sl _a(new LCLS),_b(new LCLS),_c(new LCLS),_d;
	{
		ILMap a;

		a.set(0,_a);
		SUT_ASSERT_EQUALS(Int,a.count(),1);
		a.set(10,_b);
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),2);
		a.set(10,_a);
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),3);
	}
	SUT_ASSERT_EQUALS(Int,_a.count(),1);
	{
		ILMap a;

		a[0] = _b;
		SUT_ASSERT_EQUALS(Int,a.count(),1);
		a[5] = _c;
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_b.count(),2);
		a[5] = _d;
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_d.count(),0);

		ILMap s(a);
		SUT_ASSERT_EQUALS(Int,s.count(),2);
		SUT_ASSERT_EQUALS(Int,_b.count(),2);

		a.remove(5);
		SUT_ASSERT_EQUALS(Int,a.count(),1);
		SUT_ASSERT_EQUALS(Int,_d.count(),0);
		s.remove(5);
		SUT_ASSERT_EQUALS(Int,s.count(),1);
		SUT_ASSERT_EQUALS(Int,_d.count(),0);
//		SUT_ASSERT(Int,a==s,"Map error.[17+]");
	}
	SUT_ASSERT_EQUALS(Int,_d.count(),0);
	{
		SLMap a;
		AString k1("key1");
		AString k2("dkstaer");
		AString k3("xvc;lkf");

		a.set(k1,_a);
		SUT_ASSERT_EQUALS(Int,a.count(),1);
		a.set(k2,_b);
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),2);
		a.set(k3,_c);
		SUT_ASSERT_EQUALS(Int,a.count(),3);
		SUT_ASSERT_EQUALS(Int,_c.count(),2);
		a.set(k3,_b);
		SUT_ASSERT_EQUALS(Int,a.count(),3);
		SUT_ASSERT_EQUALS(Int,_b.count(),3);
	}
	SUT_ASSERT_EQUALS(Int,_c.count(),1);
	{
		SLMap a;
		AString k1("sgd");
		AString k2("ggdsgf");
		AString k3("xvdsgfrc;gre");

		a[k1] = _a;
		SUT_ASSERT_EQUALS(Int,a.count(),1);
		a[k2] = _c;
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),2);
		a[k3] = _c;
		SUT_ASSERT_EQUALS(Int,a.count(),3);
		SUT_ASSERT_EQUALS(Int,_c.count(),3);

		SLMap s(a);
		SUT_ASSERT_EQUALS(Int,s.count(),3);
		SUT_ASSERT_EQUALS(Int,_c.count(),3);

		a.remove(k1);
		SUT_ASSERT_EQUALS(Int,a.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),2);
		s.remove(k1);
		SUT_ASSERT_EQUALS(Int,s.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),1);
		s[k3] = _a;
		SUT_ASSERT_EQUALS(Int,s.count(),2);
		SUT_ASSERT_EQUALS(Int,_a.count(),2);
//		SUT_ASSERT(Int,a!=s,"Map error.[39+]");
	}
	SUT_ASSERT_EQUALS(Int,_b.count(),1);
}