// 
// Event.cpp
// 
// Copylight(C) 2007 Ó

#include "stdafx.h"
#include "../scpl/Event.h"
#include <windows.h>

namespace scpl{

	void Event::_hclose(HANDLE h){CloseHandle(h);}

	void Event::init(ctstr eventName,bool state,bool manualReset)throw(WinAPIExc){
		HANDLE h = CreateEvent(NULL,manualReset,state,eventName);
		if(!h) throw WinAPIExc();
		_FREEUSER(_Handle,_hclose);
		_Handle = h;
	}
	bool Event::setSignal(){return (SetEvent(_Handle)!=0);}
	bool Event::resetSignal(){return (ResetEvent(_Handle)!=0);}
	bool Event::pulseSignal(){return (PulseEvent(_Handle)!=0);}
	bool Event::checkSignal(DWORD time){return _Handle?(WaitForSingleObject(_Handle,time) == WAIT_OBJECT_0):false;}
	void Event::waitSignal(DWORD time){while(WaitForSingleObject(_Handle,time) == WAIT_OBJECT_0);}

} // namespace scpl