// 
// sut.h
// 
// Copyright(C) 2007 Ó
#ifndef _sut_INCLUDED_
#define _sut_INCLUDED_

#include <process.h>
#include <stdio.h>

namespace scpl{

	/*
		sut(Simple Unit Test)́APȃeXgs߂̊֐QłB
		L̃}N֐gp邾ŃeXgs܂B

		ꂼ̊֐̏ɂ
		nꂽ]̌ʂ^̏ꍇ͂̂܂ܖ߂A
		Ȕꍇɂ̏ꏊit@Cƍsʒujƕ]̒l\A
		ASSARTn֐̏ꍇ́Aexit(-1)ĂяoďI܂B
		iCHECKn֐̏ꍇ͕\̂݁j
		IOɈꎞ~sꍇ́A
		STOP̕t}N֐gp邩A
		USE_SUT_ASSERT_STOP`ĎgpĂB

		e}N֐̈ɂ
		V   - XlyYl̕\^CvBIntEHexEDblIB
		B   - eXg]B
		X   - eXg]鍶ӒlB
		Y   - eXg]EӒlB

	*/
	namespace sut{

#define SUT_ASSERT_STOP(V,B) scpl::sut::_assert_stop_##V(__FILE__,__LINE__,#B,B)
#define SUT_ASSERT_EQUALS_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)==(Y)),"==",#X,#Y,X,Y)
#define SUT_ASSERT_NOTEQUALS_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)!=(Y)),"!=",#X,#Y,X,Y)
#define SUT_ASSERT_ABOVE_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)<(Y)),"<",#X,#Y,X,Y)
#define SUT_ASSERT_BELOW_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)>(Y)),">",#X,#Y,X,Y)
#define SUT_ASSERT_EQAB_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)<=(Y)),"<=",#X,#Y,X,Y)
#define SUT_ASSERT_EQBL_STOP(V,X,Y) scpl::sut::_assert_equals_stop_##V(__FILE__,__LINE__,((X)>=(Y)),">=",#X,#Y,X,Y)

#ifdef USE_SUT_ASSERT_STOP
#define SUT_ASSERT(V,B) SUT_ASSERT_STOP(V,B)
#define SUT_ASSERT_EQUALS(V,X,Y) SUT_ASSERT_EQUALS_STOP(V,X,Y)
#define SUT_ASSERT_NOTEQUALS(V,X,Y) SUT_ASSERT_NOTEQUALS_STOP(V,X,Y)
#define SUT_ASSERT_ABOVE(V,X,Y) SUT_ASSERT_ABOVE_STOP(V,X,Y)
#define SUT_ASSERT_BELOW(V,X,Y) SUT_ASSERT_BELOW_STOP(V,X,Y)
#define SUT_ASSERT_EQAB(V,X,Y) SUT_ASSERT_EQAB_STOP(V,X,Y)
#define SUT_ASSERT_EQBL(V,X,Y) SUT_ASSERT_EQBL_STOP(V,X,Y)
#else
#define SUT_ASSERT(V,B) scpl::sut::_assert_##V(__FILE__,__LINE__,#B,B)
#define SUT_ASSERT_EQUALS(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)==(Y)),"==",#X,#Y,X,Y)
#define SUT_ASSERT_NOTEQUALS(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)!=(Y)),"!=",#X,#Y,X,Y)
#define SUT_ASSERT_ABOVE(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)<(Y)),"<",#X,#Y,X,Y)
#define SUT_ASSERT_BELOW(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)>(Y)),">",#X,#Y,X,Y)
#define SUT_ASSERT_EQAB(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)<=(Y)),"<=",#X,#Y,X,Y)
#define SUT_ASSERT_EQBL(V,X,Y) scpl::sut::_assert_equals_##V(__FILE__,__LINE__,((X)>=(Y)),">=",#X,#Y,X,Y)
#endif

#define SUT_CHECK(V,X) scpl::sut::_check_##V(__FILE__,__LINE__,#X,X)
#define SUT_CHECK_EQUALS(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)==(Y)),"==",#X,#Y,X,Y)
#define SUT_CHECK_NOTEQUALS(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)!=(Y)),"!=",#X,#Y,X,Y)
#define SUT_CHECK_ABOVE(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)<(Y)),"<",#X,#Y,X,Y)
#define SUT_CHECK_BELOW(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)>(Y)),">",#X,#Y,X,Y)
#define SUT_CHECK_EQAB(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)<=(Y)),"<=",#X,#Y,X,Y)
#define SUT_CHECK_EQBL(V,X,Y) scpl::sut::_check_equals_##V(__FILE__,__LINE__,((X)>=(Y)),">=",#X,#Y,X,Y)

		void _show_singleInt(char*,int,char*,int);
		void _show_doubleInt(char*,int,char*,char*,char*,int,int);
		void _show_singleHex(char*,int,char*,int);
		void _show_doubleHex(char*,int,char*,char*,char*,int,int);
		void _show_singleDbl(char*,int,char*,double);
		void _show_doubleDbl(char*,int,char*,char*,char*,double,double);

#define _SUT_ASSERT_S(Func,H) if(x == 0){_show_single##Func(fname,line,sx,x);H}
#define _SUT_ASSERT_D(Func,H) if(!b){_show_double##Func(fname,line,v,sx,sy,x,y);H}

#define _SUT_ASSERT exit(-1);
#define _SUT_STOP getchar();exit(-1);
#define _SUT_CHECK

		inline void _assert_Int(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Int,_SUT_ASSERT)}
		inline void _assert_equals_Int(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Int,_SUT_ASSERT)}
		inline void _assert_stop_Int(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Int,_SUT_STOP)}
		inline void _assert_equals_stop_Int(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Int,_SUT_STOP)}
		inline void _check_Int(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Int,_SUT_CHECK)}
		inline void _check_equals_Int(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Int,_SUT_CHECK)}

		inline void _assert_Hex(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Hex,_SUT_ASSERT)}
		inline void _assert_equals_Hex(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Hex,_SUT_ASSERT)}
		inline void _assert_stop_Hex(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Hex,_SUT_STOP)}
		inline void _assert_equals_stop_Hex(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Hex,_SUT_STOP)}
		inline void _check_Hex(char* fname,int line,char* sx,int x){_SUT_ASSERT_S(Hex,_SUT_CHECK)}
		inline void _check_equals_Hex(char* fname,int line,bool b,char* v,char* sx,char* sy,int x,int y){_SUT_ASSERT_D(Hex,_SUT_CHECK)}

		inline void _assert_Dbl(char* fname,int line,char* sx,double x){_SUT_ASSERT_S(Dbl,_SUT_ASSERT)}
		inline void _assert_equals_Dbl(char* fname,int line,bool b,char* v,char* sx,char* sy,double x,double y){_SUT_ASSERT_D(Dbl,_SUT_ASSERT)}
		inline void _assert_stop_Dbl(char* fname,int line,char* sx,double x){_SUT_ASSERT_S(Dbl,_SUT_STOP)}
		inline void _assert_equals_stop_Dbl(char* fname,int line,bool b,char* v,char* sx,char* sy,double x,double y){_SUT_ASSERT_D(Dbl,_SUT_STOP)}
		inline void _check_Dbl(char* fname,int line,char* sx,double x){_SUT_ASSERT_S(Dbl,_SUT_CHECK)}
		inline void _check_equals_Dbl(char* fname,int line,bool b,char* v,char* sx,char* sy,double x,double y){_SUT_ASSERT_D(Dbl,_SUT_CHECK)}

#undef _SUT_ASSERT_S
#undef _SUT_ASSERT_D
#undef _SUT_ASSERT
#undef _SUT_STOP
#undef _SUT_CHECK

	} // namespace sut
} // namespace scpl
#endif