// 
// frag.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _frag_INCLUDED_
#define _frag_INCLUDED_
#include "scpl.h"

/*
	tO𑀍삷CC֐QłB
*/

namespace scpl{

	/* 2oCgf[^킹4oCgf[^ɂ܂B */
	inline ulong lmake2(ushort upper,ushort under){return (upper << 16) | under;}
	/* l1oCgf[^킹4oCgf[^ɂ܂B */
	inline ulong lmake4(byte _24,byte _16,byte _8,byte _0){return (_24 << 24) | (_16 << 16) | (_8 << 8) | _0;}

	/* 1oCgf[^킹2oCgf[^ɂ܂B */
	inline ushort smake2(byte upper,byte under){return static_cast<ushort>((upper << 8) | under);}

	/* 4oCgf[^킹8oCgf[^ɂ܂B */
	inline ui64 i64make2(ulong upper,ulong under){return (static_cast<ui64>(upper) << 32) | under;}
	/* l2oCgf[^킹8oCgf[^ɂ܂B */
	inline ui64 i64make4(ushort _24,ushort _16,ushort _8,ushort _0){return (static_cast<ui64>(_24) << 48) | (static_cast<ui64>(_16) << 32) | (_8 << 16) | _0;}
	/* 1oCgf[^킹8oCgf[^ɂ܂B */
	inline ui64 i64make8(byte _56,byte _48,byte _40,byte _32,byte _24,byte _16,byte _8,byte _0){
		return
			(static_cast<ui64>(_56) << 56) |
			(static_cast<ui64>(_48) << 48) |
			(static_cast<ui64>(_40) << 40) |
			(static_cast<ui64>(_32) << 32) |
			(_24 << 24) |
			(_16 << 16) |
			(_8  <<  8) |
			_0;
	}

	/* 4oCgf[^2oCgA2oCgɕ܂B */
	inline void lsplit2(ulong src,ushort& upper,ushort& under){
		upper = static_cast<ushort>(src>>16);
		under = static_cast<ushort>(src);
	}
	/* 4oCgf[^l1oCgf[^ɕ܂B */
	inline void lsplit4(ulong src,byte& _24,byte& _16,byte& _8,byte& _0){
		_24 = static_cast<byte>(src>>24);
		_16 = static_cast<byte>(src>>16);
		_8  = static_cast<byte>(src>>8);
		_0  = static_cast<byte>(src);
	}

	/* 2oCgf[^1oCgA1oCgɕ܂B */
	inline void ssplit2(ushort src,byte& upper,byte& under){
		upper = static_cast<byte>(src>>8);
		under = static_cast<byte>(src);
	}

	/* 8oCgf[^4oCgA4oCgɕ܂B */
	inline void i64split2(ui64 src,ulong& upper,ulong& under){
		upper = static_cast<ulong>(src>>32);
		under = static_cast<ulong>(src);
	}
	/* 8oCgf[^l2oCgf[^ɕ܂B */
	inline void i64split4(ui64 src,ushort& _48,ushort& _32,ushort& _16,ushort& _0){
		_48 = static_cast<ushort>(src>>48);
		_32 = static_cast<ushort>(src>>32);
		_16 = static_cast<ushort>(src>>16);
		_0  = static_cast<ushort>(src);
	}
	/* 8oCgf[^𔪂1oCgf[^ɕ܂B */
	inline void i64split8(ui64 src,byte& _56,byte _48,byte& _40,byte& _32,byte& _24,byte& _16,byte& _8,byte& _0){
		_56 = static_cast<byte>(src>>56);
		_48 = static_cast<byte>(src>>48);
		_40 = static_cast<byte>(src>>40);
		_32 = static_cast<byte>(src>>32);
		_24 = static_cast<byte>(src>>24);
		_16 = static_cast<byte>(src>>16);
		_8  = static_cast<byte>(src>> 8);
		_0  = static_cast<byte>(src);
	}

	/* 4oCgf[^̏2oCgԂ܂B */
	inline ushort lget2_up(ulong src){return static_cast<ushort>(src>>16);}
	/* 4oCgf[^̉2oCgԂ܂B */
	inline ushort lget2_un(ulong src){return static_cast<ushort>(src);}

	/* 4oCgf[^1oCgf[^(24-31bit)Ԃ܂B */
	inline byte lget4_24(ulong src){return static_cast<byte>(src>>24);}
	/* 4oCgf[^1oCgf[^(16-24bit)Ԃ܂B */
	inline byte lget4_16(ulong src){return static_cast<byte>(src>>16);}
	/* 4oCgf[^1oCgf[^( 8-15bit)Ԃ܂B */
	inline byte lget4_8 (ulong src){return static_cast<byte>(src>>8);}
	/* 4oCgf[^1oCgf[^( 0- 7bit)Ԃ܂B */
	inline byte lget4_0 (ulong src){return static_cast<byte>(src);}

	/* 2oCgf[^̏1oCgԂ܂B */
	inline byte sget2_up(ushort src){return static_cast<byte>(src>>8);}
	/* 2oCgf[^̉1oCgԂ܂B */
	inline byte sget2_un(ushort src){return static_cast<byte>(src);}

	/* 8oCgf[^̏4oCgԂ܂B */
	inline ulong i64get2_up(ui64 src){return static_cast<ulong>(src>>32);}
	/* 8oCgf[^̉4oCgԂ܂B */
	inline ulong i64get2_un(ui64 src){return static_cast<ulong>(src);}

	/* 8oCgf[^2oCgf[^(48-63bit)Ԃ܂B */
	inline ushort i64get4_48(ui64 src){return static_cast<ushort>(src>>48);}
	/* 8oCgf[^2oCgf[^(32-47bit)Ԃ܂B */
	inline ushort i64get4_32(ui64 src){return static_cast<ushort>(src>>32);}
	/* 8oCgf[^2oCgf[^(16-31bit)Ԃ܂B */
	inline ushort i64get4_16(ui64 src){return static_cast<ushort>(src>>16);}
	/* 8oCgf[^2oCgf[^( 0-15bit)Ԃ܂B */
	inline ushort i64get4_0 (ui64 src){return static_cast<ushort>(src);}

	/* 8oCgf[^1oCgf[^(56-63bit)Ԃ܂B */
	inline byte i64get8_56(ui64 src){return static_cast<byte>(src>>56);}
	/* 8oCgf[^1oCgf[^(48-55bit)Ԃ܂B */
	inline byte i64get8_48(ui64 src){return static_cast<byte>(src>>48);}
	/* 8oCgf[^1oCgf[^(40-47bit)Ԃ܂B */
	inline byte i64get8_40(ui64 src){return static_cast<byte>(src>>40);}
	/* 8oCgf[^1oCgf[^(32-39bit)Ԃ܂B */
	inline byte i64get8_32(ui64 src){return static_cast<byte>(src>>32);}
	/* 8oCgf[^1oCgf[^(24-31bit)Ԃ܂B */
	inline byte i64get8_24(ui64 src){return static_cast<byte>(src>>24);}
	/* 8oCgf[^1oCgf[^(16-23bit)Ԃ܂B */
	inline byte i64get8_16(ui64 src){return static_cast<byte>(src>>16);}
	/* 8oCgf[^1oCgf[^( 8-15bit)Ԃ܂B */
	inline byte i64get8_8 (ui64 src){return static_cast<byte>(src>>8);}
	/* 8oCgf[^1oCgf[^( 0- 7bit)Ԃ܂B */
	inline byte i64get8_0 (ui64 src){return static_cast<byte>(src);}

	/* w肵rbgʒũtOĂ邩Ԃ܂B */
	template <class T>
	inline bool isFragOnBit(T frag,byte bit){return ((frag>>bit)&1)==1;}

	/* w肵tOSėĂ邩Ԃ܂B */
	template <class T>
	inline bool isFragOnAll(T frag,T check){return (frag&check)==check;}

	/* w肵tÔꂩĂ邩Ԃ܂B */
	template <class T>
	inline bool isFragOnOr(T frag,T check){return (frag&check)!=0;}

	/* tOSĔ]̂Ԃ܂B */
	template <class T>
	inline T fragRev(T frag){return ~frag;}
	/* tO}XNgĔ]܂B */
	template <class T>
	inline T fragRev(T frag,T mask){return frag^mask;}

} // namespace scpl

#endif