// 
// WString.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _WString_INCLUDED_
#define _WString_INCLUDED_
#include "Buffer.h"

namespace scpl{

	/*
		UNICODE 𑀍삷NXłB
	*/

	class WString{
		typedef WString				self;
		typedef Buffer<wchar_t,2>	buffer;
		typedef wchar_t*			ptr;
		typedef const wchar_t*		cptr;
		typedef wchar_t&			ind;
		typedef const wchar_t&		cind;

		// ƗpB
		WString(buffer* buf,ulong useCount):_Text(buf),_UseCount(useCount){}
		buffer* getBuf(){return &_Text;}

	public:
		/* ̕쐬܂B */
		WString():_UseCount(0){}

		/*
			̕쐬܂B炩ߎw肵mۂ܂B
			bufCount - mۂ镶B
		*/
		WString(ulong bufCount)throw(OutOfMemExc):_Text(bufCount,true),_UseCount(0){}

		/*
			񂩂쐬܂B
			s     - 
			count - s ̕B -1 w肷ƑSĎg܂B
		*/
		WString(cwstr s,long count=-1)throw(OutOfMemExc):_UseCount(0){copy(s,count);}

		/* Rs[RXgN^B */
		WString(const self& t)throw(OutOfMemExc){copy(t.get());}

		/* Ԃ܂B */
		operator cwstr()const{return _Text.get();}
		/* 񂪋󂩂Ԃ܂B */
		bool operator!()const{return _UseCount==0;}

		/*
			p̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr begin()const{return _Text.get();}
		/*
			p̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr end()const{return _Text?(_Text.get()+_UseCount):NULL;}
		/*
			tp̍ŏ̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr rbegin()const{return _Text?(_Text.get()+_UseCount-1):NULL;}
		/*
			tp̍Ō̈ʒu|C^Ԃ܂B
			f[^݂ȂƂNULLԂ܂B
		*/
		ptr rend()const{return _Text?(_Text.get()-1):NULL;}

		/* Ԃ܂B */
		ulong count()const{return _UseCount;}
		/* mۂĂ镶Ԃ܂B */
		ulong capacity()const{return _Text.count();}
		/* 񂪋󂩂Ԃ܂B */
		bool empty()const{return _UseCount == 0;}

		/* ܂B */
		self& operator=(cwstr s)throw(OutOfMemExc){copy(s);return *this;}
		/* l𕶎ɕϊđ܂B */
		self& operator=(long l)throw(OutOfMemExc){clear(true);lastInNum(l);return *this;}
		self& operator=(ulong l)throw(OutOfMemExc){clear(true);lastInUNum(l);return *this;}

		/* ɒǉ܂B */
		self& operator+=(cwstr s)throw(OutOfMemExc){return lastInStr(s);}
		/* l𕶎ɕϊĒǉ܂B */
		self& operator+=(long l)throw(OutOfMemExc){return lastInNum(l);}
		self& operator+=(ulong l)throw(OutOfMemExc){return lastInUNum(l);}

		/* Ȃ܂B */
		self operator+(cwstr s)const{return strcat(_Text.get(),s);}
		self operator+(self& s)const{return strcat(get(),s);}

		/*
			w肵ʒuɂ镶Ԃ܂B
			i - 擪̕ʒuB{0 <= i < count()} ܂ł͈̔
		*/
		ind at(ulong i)const throw(InvalidParamExc,InvalidCallExc);
		/* 擪ɂ镶Ԃ܂B */
		ind atFirst()throw(InvalidCallExc){return at(0);}
		cind atFirst()const throw(InvalidCallExc){return at(0);}
		/* Ōɂ镶Ԃ܂B */
		ind atLast()throw(InvalidCallExc){return at((_UseCount == 0)?0:_UseCount - 1);}
		cind atLast()const throw(InvalidCallExc){return at((_UseCount == 0)?0:_UseCount - 1);}

		/* Ԃ܂B */
		wstr get()const{return _Text.get();}

		/*
			w肵ʒuɑ}܂B
			c     - }镶
			index - }ʒuB{0 <= index <= count()} ܂ł͈̔
		*/
		self& insertChar(wchar_t c,ulong index)throw(InvalidParamExc,OutOfMemExc);
		/*
			擪ɑ}܂B
			c - }镶
		*/
		self& firstInChar(wchar_t c)throw(OutOfMemExc){return insertChar(c,0);}
		/*
			Ōɒǉ܂B
			c - ǉ镶
		*/
		self& lastInChar(wchar_t c)throw(OutOfMemExc){return insertChar(c,_UseCount);}
		/*
			Ōɒǉ܂B
			c      - ǉ镶
			߂l - ǉłǂB
		*/
		bool outputChar(wchar_t c);

		/*
			w肵ʒuɑ}܂B
			text  - }镶
			index - }ʒuB{0 <= index <= count()} ܂ł͈̔
		*/
		self& insertStr(cwstr text,long count,ulong index)throw(InvalidParamExc,OutOfMemExc);
		/*
			擪ɑ}܂B
			text - }镶
		*/
		self& firstInStr(cwstr text,long count=-1)throw(OutOfMemExc){return insertStr(text,count,0);}
		/*
			Ōɒǉ܂B
			text - ǉ镶
		*/
		self& lastInStr(cwstr text,long count=-1)throw(OutOfMemExc){return insertStr(text,count,_UseCount);}
		/*
			Ōɒǉ܂B
			text   - ǉ镶
			߂l - ǉłǂB
		*/
		bool outputStr(cwstr text);

		/*
			l𕶎ɕϊAw肵ʒuɑ}܂B
			l     - }鐔l
			index - }ʒuB{0 <= index <= count()} ܂ł͈̔
			radix - 
		*/
		self& insertNum(long l,ulong index,long radix=10)throw(InvalidParamExc,OutOfMemExc);
		/*
			l𕶎ɕϊA擪ɑ}܂B
			l     - }鐔l
			radix - 
		*/
		self& firstInNum(long l,long radix=10)throw(OutOfMemExc){return insertNum(l,0,radix);}
		/*
			l𕶎ɕϊAŌɒǉ܂B
			l     - }鐔l
			radix - 
		*/
		self& lastInNum(long l,long radix=10)throw(OutOfMemExc){return insertNum(l,_UseCount,radix);}
		/*
			Ōɒǉ܂B
			l     - }鐔l
			radix - 
			߂l - ǉłǂB
		*/
		bool outputNum(long l,long radix=10);

		/*
			l𕶎ɕϊAw肵ʒuɑ}܂B
			l     - }鐔l
			index - }ʒuB{0 <= index <= count()} ܂ł͈̔
			radix - 
		*/
		self& insertUNum(ulong l,ulong index,long radix=10)throw(InvalidParamExc,OutOfMemExc);
		/*
			l𕶎ɕϊA擪ɑ}܂B
			l     - }鐔l
			radix - 
		*/
		self& firstInUNum(ulong l,long radix=10)throw(OutOfMemExc){return insertUNum(l,0,radix);}
		/*
			l𕶎ɕϊAŌɒǉ܂B
			l     - }鐔l
			radix - 
		*/
		self& lastInUNum(ulong l,long radix=10)throw(OutOfMemExc){return insertUNum(l,_UseCount,radix);}
		/*
			Ōɒǉ܂B
			l     - }鐔l
			radix - 
			߂l - ǉłǂB
		*/
		bool outputUNum(ulong l,long radix=10);

		/*
			w肵ʒuɑ}܂B
			text  - }镶
			index - }ʒuB{0 <= index <= count()} ܂ł͈̔
		*/
		self& insert(const self& text,ulong index)throw(InvalidParamExc,OutOfMemExc){
			return insertStr(text,text.count(),index);
		}
		/*
			擪ɑ}܂B
			text - }镶
		*/
		self& firstIn(const self& text)throw(OutOfMemExc){return insert(text,0);}
		/*
			Ōɒǉ܂B
			text - ǉ镶
		*/
		self& lastIn(const self& text)throw(OutOfMemExc){return insert(text,_UseCount);}
		/*
			Ōɒǉ܂B
			text   - ǉ镶
			߂l - ǉłǂB
		*/
		bool output(const self& text);

		/*
			w肵ʒu̕폜܂B
			index - 폜ʒuB{0 <= index < count()} ܂ł͈̔
		*/
		void removeAt(ulong index)throw(InvalidParamExc,InvalidCallExc);
		/* 擪̕폜܂B */
		void firstOut()throw(InvalidCallExc){removeAt(0);}
		/* Ō̕폜܂B */
		void lastOut()throw(InvalidCallExc){removeAt(count() - 1);}

		/*
			w肵͈͂̕폜܂B
			indexL - 폜ŏ̈ʒuB
			indexR - 폜Ō̈ʒuB
		*/
		void erage(ulong indexL,ulong indexR)throw(InvalidParamExc,InvalidCallExc);
		/*
			擪w肵폜܂B
			c - 폜镶
		*/
		void firstOut(ulong c)throw(InvalidParamExc,InvalidCallExc){erage(0,c);}
		/*
			Ōw肵폜܂B
			c - 폜镶
		*/
		void lastOut(ulong c)throw(InvalidParamExc,InvalidCallExc){erage(count() - c,c);}

		/*
			ɂ܂B
			noClearCapacity - gpĂ͈͂mۂ܂܂ɂ邩ǂ
		*/
		void clear(bool noClearCapacity = false);

		/*
			񂩂Rs[܂B
			s     - 
			count - s ̕B -1 w肷ƑSĎg܂B
		*/
		void copy(cwstr s,long count=-1)throw(OutOfMemExc);
		/* Rs[܂B */
		void copy(self& s)throw(OutOfMemExc){if(&s != this) copy(s.get());}

		/* ւ܂B */
		void swap(self& t){
			_Text.swap(t._Text);
			scpl::swap(_UseCount,t._UseCount);
		}

		/* 񂪈vĂ邩Ԃ܂B */
		bool equals(cwstr s)const;

		/*
			w肵݂邩𒲂ׂ܂B
			c      - ׂ镶
			߂l - ŏɌʒuB݂Ȃꍇ -1
		*/
		long find(wchar_t c)const;

		/*
			w肵񂪑݂邩𒲂ׂ܂B
			c      - ׂ镶
			߂l - ŏɌʒuB݂Ȃꍇ -1
		*/
		long find(cwstr c)const;

		/* ̉pSďɂ܂B */
		void toLower();
		/* ̉pSđ啶ɂ܂B */
		void toUpper();

		/*
			mۂĂw肵܂B
			bufCount - mۂĂ
		*/
		void adjust(ulong bufCount=0){_Text.aResize(_UseCount + bufCount + 1,true);}

		/* ̕AԂ܂B */
		static WString strcat(cwstr a,cwstr b)throw(OutOfMemExc);

	private:
		buffer _Text;
		ulong _UseCount;

	};

	bool operator==(const WString& l,const WString& r);
	bool operator==(cwstr l,const WString& r);
	bool operator==(const WString& l,cwstr r);
	bool operator!=(const WString& l,const WString& r);
	bool operator!=(cwstr l,const WString& r);
	bool operator!=(const WString& l,cwstr r);

} // namespace scpl
#endif