/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.foldermenu;

import java.util.ResourceBundle;

/**
 *
 * @author Yu-Tang
 */
public class L10n {
    
    private static final ResourceBundle bundle;
    
    static {
        bundle = ResourceBundle.getBundle("org/omegat/plugin/foldermenu/Bundle");
    }
    
    // for menu

    public static String getFoldersMenuLabel() {
        return bundle.getString("FOLDERS_MENU_LABEL");
    }
    
    public static String getProjectRootMenuLabel() {
        return bundle.getString("PROJECT_ROOT_MENU_LABEL");
    }
    
    public static String getUserConfigMenuLabel() {
        return bundle.getString("USER_CONFIG_MENU_LABEL");
    }

    // for Word

    public static String getWordWindowCaption() {
        return bundle.getString("WORD_WINDOW_CAPTION");
    }
    
    // for error

    public static String getErrMsgFileHasNoAssoc() {
        return bundle.getString("ERROR_FILE_HAS_NO_ASSOC");
    }

}
