/**
 * ************************************************************************
 * Moenizer - Allow to set background image for OmegaT.
 *
 * Copyright (C) 2014 Yu Tang Home page: http://sourceforge.jp/users/yu-tang/
 * Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/
 *
 * This file is part of plugin for OmegaT. http://www.omegat.org/
 *
 * License: GNU GPL version 3 or (at your option) any later version.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *************************************************************************
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;

/**
 * Abstract class for effects
 *
 * @author Yu-Tang
 */
public abstract class Effect {

    public enum Type {
        Basic, Slide
    }

    public static Effect create(Type type, Map conf) throws Exception {
        final String CLASS_NAME = Effect.class.getPackage().getName() + "." + type.name() + "Effect";
        Class<? extends Effect> clazz = (Class<? extends Effect>) Class.forName(CLASS_NAME);
        Class<?>[] types = {Map.class};
        Constructor<? extends Effect> constructor = clazz.getConstructor(types);
        Object[] args = {conf};
        Effect newInstance = constructor.newInstance(args);
        return newInstance;
    }

    protected <T> T get(String key, Map<String, Object> config, T valueDefault) {
        return config.containsKey(key) ? (T) config.get(key) : valueDefault;
    }

    /**
     * Effect を適用します。
     * @param ui      操作対象となる UI モデルです。
     * @param service 繰り返しの処理が必要となる場合は、この service を使って
     *                 タスクを登録します。テーマが変更になった場合は、service
     *                 側でタスクを終了します。
     */
    public abstract void invoke(MoeUI ui, ScheduledThreadPoolExecutor service);
}
