/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2015 Yu Tang
               Home page: http://osdn.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.osdn.users.yutang.omegat.plugin.foldermenu;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileSystemView;
import org.openide.awt.Mnemonics;

/**
 * Factory class for JMenu and JMenuItem
 * 
 * @author Yu Tang
 */
public class MenuFactory {

    /** Defeats instantiation. */
    private MenuFactory() {}

    public static JMenuItem createMenuItem(final String path) {
        File file = new File(path);
        return createMenuItemImpl(file, file.getName(), false);
    }

    public static JMenuItem createMenuItem(final String path, final String titleKey) {
        return createMenuItemImpl(new File(path), titleKey, true);
    }

    public static JMenuItem createMenuItem(final File file) {
        return createMenuItemImpl(file, file.getName(), false);
    }

    public static JMenuItem createMenuItem(final File file, final String titleKey) {
        return createMenuItemImpl(file, titleKey, true);
    }

    private static JMenuItem createMenuItemImpl(final File file, final String label, final boolean toBeLocalized) {
        JMenuItem m;
        Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
        if (file.isDirectory()) {
            JMenu mnu = new JMenu();
            mnu.setIcon(icon);
            mnu.addMenuListener(Listeners.getMenuListener()); // to create submenu
            mnu.addMenuKeyListener(Listeners.getMenuKeyListener()); // to open a folder with enter key
            mnu.addMouseListener(Listeners.getMouseListener()); // to open a folder with mouse clicking
            m = mnu;
        } else {
            m = new JMenuItem(icon);
        }

        // label string
        if (toBeLocalized) {
            Mnemonics.setLocalizedText(m, label);
        } else {
            m.setText(label);
        }

        if (file.exists()) {
            m.setActionCommand(file.getAbsolutePath());
            m.addActionListener(Listeners.getActionListener());
            String name = file.getName();
            if (!name.equals(label)) {
                try {
                    m.setToolTipText(file.getCanonicalPath());
                } catch (IOException ex) {
                    m.setToolTipText(name);
                }
            }
        } else {
            m.setEnabled(false);
        }
        return m;
    }
}
