/**************************************************************************
 FolderMenu - easy access to project folders from menu.
 
 Copyright (C) 2013-2015 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.osdn.users.yutang.omegat.plugin.foldermenu;

import java.util.ResourceBundle;

/**
 * Manage localization.
 * 
 * @author Yu Tang
 */
public class L10n {

    public enum Entry {
        // for menu
        FOLDERS_MENU_LABEL,
        PROJECT_ROOT_MENU_LABEL,
        USER_CONFIG_MENU_LABEL,
        APPLICATION_ROOT_MENU_LABEL,
        SOURCE_DOC_MENU_LABEL,
        TARGET_DOC_MENU_LABEL,

        // for Word
        WORD_WINDOW_CAPTION,
        
        // for error
        ERROR_FILE_HAS_NO_ASSOC
        ;

        @Override
        public String toString() {
            return bundle.getString(this.name());
        }
    }
    
    private static final ResourceBundle bundle = ResourceBundle.getBundle(L10n.class.getPackage().getName() + ".Bundle");
}
