/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.moenizer.imageloader;

import java.awt.image.BufferedImage;

/**
 * Interface for Image Loader
 * 
 * calling order is:
 * 1. availableNext() ... exit from loop if returned false
 * 2. readyForNextImage()
 * 3. getNextInterval() ... skiped first time
 * 4. getNextImage()
 * ... loop back to step 1
 * 
 * @author Yu-Tang
 */
public interface IImageLoader {

    /**
     * get if next image available.
     * @return bool. 
     */
    boolean availableNext();

    /**
     * get next interval.
     * This method is not called at first time loop.
     * @return long by milliseconds
     */
    long getNextInterval();

    /**
     * Do anything should be done for the next image.
     * Calling before getNextImage().
     */
    void readyForNextImage();

    /**
     * get next image.
     * @return BufferedImage object. Can be null if image is not available.
     */
    BufferedImage getNextImage();
    
}
