/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2013 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.plugin.moenizer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.plugin.moenizer.imageloader.IImageLoader;
import org.omegat.plugin.moenizer.imageloader.ImageLoader;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

/**
 * allow to set background image
 * 
 * @author Yu-Tang
 */
public class Moenizer implements IApplicationEventListener, IProjectEventListener {

    private IImageLoader imageLoader;
    private MoeUI ui;
    
    
    @SuppressWarnings("LeakingThisInConstructor")
    public Moenizer() {
        CoreEvents.registerApplicationEventListener(this);
        CoreEvents.registerProjectChangeListener(this);
        
        ui = null;
        imageLoader = ImageLoader.getInstance();
        // この時点ではまだウィンドウがインスタンス化されていないので、
        // ウィンドウに対する処理は少し待つ。
        
        (new SlideShow()).execute();
    }

    @Override
    public void onApplicationStartup() {
        try {
            ui = MoeUI.getMoeUI();

            // この時点でコンポーネントの透過設定をしても反映されない（タイミング？）。
            // Workaround として、invokeLater でキューに突っ込んで、後で処理する。
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    CoreEvents.unregisterApplicationEventListener(Moenizer.this);
                    ui.transparent();
                }
            });
            //CoreEvents.unregisterApplicationEventListener(this); // ここで発行すると、スレッドエラーになるので注意
        } catch(Exception e) {
            Log.log("Error raised at " + this.getClass().getCanonicalName() + ".onApplicationStartup()\n" + e);
        }
    }

    @Override
    public void onApplicationShutdown() {
        // not used.
    }

    @Override
    public void onProjectChanged(PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
        case CREATE:
        case LOAD:
            // ここですぐ透過処理をしてもうまく適用されないので、後まわしにする。
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    CoreEvents.unregisterProjectChangeListener(Moenizer.this);
                    ui.transparentEditor();
                }
            });
            
            // 一回 Editor の透過処理をしたら、透過状態が維持されるので、二回目
            // 以降は、透過処理は不要。
            //CoreEvents.unregisterProjectChangeListener(this); // ここで発行すると、スレッドエラーになるので注意
            break;
        case CLOSE:
            break;
        }
    }
    
    private class SlideShow extends SwingWorker<Object, Void> {
        private long interval = -1;
        
        @Override
        protected Object doInBackground() throws Exception {
            while (imageLoader.availableNext()) {
                imageLoader.readyForNextImage();
                interval = interval < 0 ? 0 : imageLoader.getNextInterval();
                if (interval > 0) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(interval);
                    } catch (InterruptedException e) { /* ignore */ }
                }
                BufferedImage image = imageLoader.getNextImage();

                if (image != null) {
                    // 初期化直後に、まだ MoeUI がインスタンス化されていない
                    // 空白時間に遭遇する可能性があるため、その場合は 0.1 秒
                    // 単位で MoeUI のインスタンス化を待機する。
                    while (ui == null) {
                        TimeUnit.MILLISECONDS.sleep(100);
                    }
                    ui.setBackground(image);
                }
            }
            return null;
        }
   }
    
}
