﻿using AutoMapper;
using CleanAuLait.Core.Mapper;
using TestNarou3.Adaptor;
using TestNarou3.Domain;
using TestNarou3.OuterEdge;

namespace TestNarou3.Core.Mapper
{
    public sealed class MapperFactory : IMapperFactory
    {
        //private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private static readonly object lockObj = new();

        private static IMapper me;

        public IMapper Instance
        {
            get
            {
                if (me != null)
                {
                    return me;
                }

                lock (lockObj)
                {
                    if (me == null)
                    {
                        me = GetMapper();
                    }

                    return me;
                }
            }
        }

        public MapperFactory()
        {
        }

        private static IMapper GetMapper()
        {
            var config = new MapperConfiguration(mapperOptions =>
            {
                mapperOptions.AddProfile<PrimitiveMappingProfile>();
                mapperOptions.AddProfile<DomainMappingProfile>();
                mapperOptions.AddProfile<AdaptorMappingProfile>();
                mapperOptions.AddProfile<OuterEdgeMappingProfile>();
            });

            config.AssertConfigurationIsValid();

            //var executionPlan = config.BuildExecutionPlan(typeof(DbConnectionSettings), typeof(IAppSettingsDbConnectionViewModel));

            return config.CreateMapper();
        }
    }
}
