﻿using NLog;
using Prism.Ioc;
using Prism.Modularity;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Interactor;

namespace TestNarou3.UseCase
{
    public class UseCaseModule : IModule
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public void RegisterTypes(IContainerRegistry containerRegistry)
        {
            ///
            /// Interactors
            ///

            containerRegistry.Register<IAppConfigLoadInteractor, AppConfigLoadInteractor>();
            containerRegistry.Register<IAppConfigSaveInteractor, AppConfigSaveInteractor>();

            containerRegistry.Register<INarouLoginInteractor, NarouLoginInteractor>();
            containerRegistry.Register<INarouLogoutInteractor, NarouLogoutInteractor>();

            containerRegistry.Register<INarouRefreshBookmarkDetailListInteractor, NarouRefreshBookmarkDetailListInteractor>();

            logger.Trace("RegisterTypes end");
        }

        public void OnInitialized(IContainerProvider containerProvider)
        {
        }
    }
}
