﻿using CleanAuLait.Domain.Service;
using CleanAuLait.UseCase.Interactor;
using CleanAuLait.UseCase.Response;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.UseCase.Interactor
{
    internal class NarouLogoutInteractor
            : AbstractUseCaseInteractor<NarouLogoutRequest, NarouLogoutResponse>
            , INarouLogoutInteractor
    {
        private readonly INarouService service;

        public NarouLogoutInteractor(INarouService service)
        {
            this.service = service;
        }

        public override NarouLogoutResponse Interact(NarouLogoutRequest req)
        {
            try
            {
                this.service.Logout();

                NarouLogoutResponse res = new();

                return res;
            }
            catch (ServiceException e)
            {
                return UseCaseResponse.Abort<NarouLogoutResponse>(e.Message);
            }
        }

    }
}
