﻿using CleanAuLait.Domain.Service;
using CleanAuLait.UseCase.Interactor;
using CleanAuLait.UseCase.Response;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.Domain.Model.Entity;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Boundary.Presenter;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.UseCase.Interactor
{
    internal class NarouLoginInteractor
            : AbstractUseCaseInteractor<NarouLoginRequest, NarouLoginResponse>
            , INarouLoginInteractor
    {
        private readonly INarouService narouService;
        private readonly IAppConfigService configService;
        private readonly INarouLoginPresenter presenter;

        public NarouLoginInteractor(
                INarouService narouService,
                IAppConfigService configService,
                INarouLoginPresenter presenter
        )
        {
            this.narouService = narouService;
            this.configService = configService;
            this.presenter = presenter;
        }

        public override NarouLoginResponse Interact(NarouLoginRequest req)
        {
            try
            {
                this.narouService.Login(req.NarouID, req.Password);

                this.configService.Update(new(req.NarouID, req.Password));

                BookmarkCategory category = this.narouService.GetBookmarkCategory();

                NarouLoginResponse res = new(category);

                return presenter.Present(req, res);
            }
            catch (ServiceException e)
            {
                return UseCaseResponse.Abort<NarouLoginResponse>(e.Message);
            }
        }

    }
}
