﻿using CleanAuLait.Domain.Service;
using CleanAuLait.UseCase.Interactor;
using CleanAuLait.UseCase.Response;
using TestNarou3.Domain.Boundary.Service;
using TestNarou3.Domain.Model.Config;
using TestNarou3.UseCase.Boundary.Interactor;
using TestNarou3.UseCase.Boundary.Presenter;
using TestNarou3.UseCase.Request;
using TestNarou3.UseCase.Response;

namespace TestNarou3.UseCase.Interactor
{
    internal class AppConfigLoadInteractor
            : AbstractUseCaseInteractor<AppConfigLoadRequest, AppConfigLoadResponse>
            , IAppConfigLoadInteractor
    {
        private readonly IAppConfigService service;
        private readonly IAppConfigLoadPresenter presenter;

        public AppConfigLoadInteractor(
                IAppConfigService service,
                IAppConfigLoadPresenter presenter
        )
        {
            this.service = service;
            this.presenter = presenter;
        }

        public override AppConfigLoadResponse Interact(AppConfigLoadRequest req)
        {
            try
            {
                AppConfig appConfig = this.service.Load();

                AppConfigLoadResponse res = new(appConfig);

                return presenter.Present(req, res);
            }
            catch (ServiceException e)
            {
                return UseCaseResponse.Abort<AppConfigLoadResponse>(e.Message);
            }
        }

    }
}
