﻿using CommunityToolkit.WinUI.UI.Controls;
using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Controls;
using Microsoft.UI.Xaml.Controls.Primitives;
using Microsoft.UI.Xaml.Data;
using Microsoft.UI.Xaml.Input;
using Microsoft.UI.Xaml.Media;
using Microsoft.UI.Xaml.Navigation;
using NLog;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using Windows.Foundation;
using Windows.Foundation.Collections;

// To learn more about WinUI, the WinUI project structure,
// and more about our project templates, see: http://aka.ms/winui-project-info.

namespace TestNarou3.OuterEdge.UI.View
{
    public sealed partial class BookmarkDetailListView : UserControl
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public IBookmarkDetailListViewModel ViewModel { get; }

        public BookmarkDetailListView(IBookmarkDetailListViewModel viewModel)
        {
            this.ViewModel = viewModel;

            this.InitializeComponent();
        }

        private void OnSorting(object sender, DataGridColumnEventArgs e)
        {
            string tag = e.Column.Tag.ToString();

            DataGridSortDirection direction = e.Column.SortDirection ?? DataGridSortDirection.Ascending;

            logger.Trace("OnSorting: tag [{0}], direction [{1}]", tag, direction.ToString());

            switch (tag)
            {
                case "Title":
                    if ((e.Column.SortDirection == null) || (direction == DataGridSortDirection.Descending))
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Title.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Title.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    break;

                case "Writer":
                    if ((e.Column.SortDirection == null) || (direction == DataGridSortDirection.Descending))
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Writer.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Writer.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    break;

                case "End":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.End.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.End.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "GeneralAllNo":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.GeneralAllNo.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.GeneralAllNo.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "Time":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Time.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.Time.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "IsStop":
                    if ((e.Column.SortDirection == null) || (direction == DataGridSortDirection.Descending))
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.IsStop.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.IsStop.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    break;

                case "GlobalPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.GlobalPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.GlobalPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "MinPerAllNo":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.MinPerAllNo.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.MinPerAllNo.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "PointPerMin":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.PointPerMin.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.PointPerMin.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "DailyPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.DailyPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.DailyPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "WeeklyPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.WeeklyPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.WeeklyPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "MonthlyPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.MonthlyPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.MonthlyPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "QuarterPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.QuarterPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.QuarterPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "YearlyPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.YearlyPoint.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.YearlyPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "FavNovelCnt":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.FavNovelCnt.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.FavNovelCnt.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "ImpressionCnt":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.ImpressionCnt.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.ImpressionCnt.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "ReviewCnt":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.ReviewCnt.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.ReviewCnt.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "AllPoint":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.AllPoint.Value, false);
                       e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.AllPoint.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "AllHyokaCnt":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.AllHyokaCnt.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByViewColumn(tag, r => r.AllHyokaCnt.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "GeneralLastUp":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.GeneralLastUp.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.GeneralLastUp.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "GeneralFirstUp":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.GeneralFirstUp.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.GeneralFirstUp.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                case "NovelUpdatedAt":
                    if (direction == DataGridSortDirection.Ascending)
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.NovelUpdatedAt.Value, false);
                        e.Column.SortDirection = DataGridSortDirection.Descending;
                    }
                    else
                    {
                        this.ViewModel.SortByValueColumn(tag, r => r.NovelUpdatedAt.Value, true);
                        e.Column.SortDirection = DataGridSortDirection.Ascending;
                    }
                    break;

                default:
                    logger.Trace("OnSorting: column not sortable.");
                    return;
            }

            // Remove sorting indicators from other columns
            foreach (var dgColumn in dg.Columns)
            {
                if (dgColumn.Tag?.ToString() != tag)
                {
                    dgColumn.SortDirection = null;
                }
            }
        }
    }
}
