﻿using AutoMapper;
using TestNarou3.Domain.Model.API;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Domain.Translator
{
    internal class BookmarkDetailListRowTranslator : IBookmarkDetailListRowTranslator
    {
        private readonly IMapper mapper;

        public BookmarkDetailListRowTranslator(IMapper mapper)
        {
            this.mapper = mapper;
        }

        public BookmarkDetailListRow Translate(NarouNovelDetailInfo info)
        {
            BookmarkDetailListRow row = info != null
                    ? mapper.Map(info, new BookmarkDetailListRow())
                    : null;

            return row;
        }

        internal static void ConfigureMapper(
                IMappingExpression<NarouNovelDetailInfo, BookmarkDetailListRow> mappingExpression)
        {
            mappingExpression
                    .ForMember(d => d.NCode,            opts => opts.MapFrom(s => s.NCode))
                    .ForMember(d => d.Title,            opts => opts.MapFrom(s => s.Title.Trim()))
                    .ForMember(d => d.Writer,           opts => opts.MapFrom(s => s.Writer))
                    .ForMember(d => d.Story,            opts => opts.MapFrom(s => s.Story))
                    .ForMember(d => d.BigGenre,         opts => opts.MapFrom(s => s.BigGenre))
                    .ForMember(d => d.Genre,            opts => opts.MapFrom(s => s.Genre))
                    .ForMember(d => d.Keyword,          opts => opts.MapFrom(s => s.Keyword))
                    .ForMember(d => d.NovelType,        opts => opts.MapFrom(s => s.NovelType))
                    .ForMember(d => d.End,              opts => opts.MapFrom(s => s.End))
                    .ForMember(d => d.GeneralAllNo,     opts => opts.MapFrom(s => s.GeneralAllNo))
                    .ForMember(d => d.Time,             opts => opts.MapFrom(s => s.Time))
                    .ForMember(d => d.IsStop,           opts => opts.MapFrom(s => s.IsStop))
                    .ForMember(d => d.IsR15,            opts => opts.MapFrom(s => s.IsR15))
                    .ForMember(d => d.IsBL,             opts => opts.MapFrom(s => s.IsBL))
                    .ForMember(d => d.IsGL,             opts => opts.MapFrom(s => s.IsGL))
                    .ForMember(d => d.IsZankoku,        opts => opts.MapFrom(s => s.IsZankoku))
                    .ForMember(d => d.IsTensei,         opts => opts.MapFrom(s => s.IsTensei))
                    .ForMember(d => d.IsTenni,          opts => opts.MapFrom(s => s.IsTenni))
                    .ForMember(d => d.GlobalPoint,      opts => opts.MapFrom(s => s.GlobalPoint))
                    .ForMember(d => d.DailyPoint,       opts => opts.MapFrom(s => s.DailyPoint))
                    .ForMember(d => d.WeeklyPoint,      opts => opts.MapFrom(s => s.WeeklyPoint))
                    .ForMember(d => d.MonthlyPoint,     opts => opts.MapFrom(s => s.MonthlyPoint))
                    .ForMember(d => d.QuarterPoint,     opts => opts.MapFrom(s => s.QuarterPoint))
                    .ForMember(d => d.YearlyPoint,      opts => opts.MapFrom(s => s.YearlyPoint))
                    .ForMember(d => d.FavNovelCnt,      opts => opts.MapFrom(s => s.FavNovelCnt))
                    .ForMember(d => d.ImpressionCnt,    opts => opts.MapFrom(s => s.ImpressionCnt))
                    .ForMember(d => d.ReviewCnt,        opts => opts.MapFrom(s => s.ReviewCnt))
                    .ForMember(d => d.AllPoint,         opts => opts.MapFrom(s => s.AllPoint))
                    .ForMember(d => d.AllHyokaCnt,      opts => opts.MapFrom(s => s.AllHyokaCnt))
                    .ForMember(d => d.GeneralFirstUp,   opts => opts.MapFrom(s => s.GeneralFirstUp))
                    .ForMember(d => d.GeneralLastUp,    opts => opts.MapFrom(s => s.GeneralLastUp))
                    .ForMember(d => d.NovelUpdatedAt,   opts => opts.MapFrom(s => s.NovelUpdatedAt))
                    .DisableCtorValidation();
        }
    }
}
