﻿using CleanAuLait.Core.Converter;
using System;
using System.Text.Json.Serialization;

namespace TestNarou3.Domain.Model.Config
{
    public record class NarouLoginSettings(
        string NarouID,
        byte[] PasswordEntropy,
        byte[] PasswordEncrypted
    )
    {
        private const int ENTROPY_LENGTH = 16;

        [JsonIgnore]
        public string Password => DecryptPassword(this.PasswordEncrypted, this.PasswordEntropy);

        public NarouLoginSettings() : this(
            NarouID: string.Empty,
            PasswordEntropy: Array.Empty<byte>(),
            PasswordEncrypted: Array.Empty<byte>()
        )
        {
        }

        public NarouLoginSettings(string id, string password) : this(
            NarouID: id,
            PasswordEntropy: GenerateEntropy(),
            PasswordEncrypted: Array.Empty<byte>()
        )
        {
            this.PasswordEncrypted = EncryptPassword(password, this.PasswordEntropy);
        }

        private static byte[] GenerateEntropy()
        {
            return CryptoHelper.GenerateEntropy(ENTROPY_LENGTH);
        }

        private static byte[] EncryptPassword(string str, byte[] entropy)
        {
            return CryptoHelper.ProtectData(str, entropy);
        }

        private static string DecryptPassword(byte[] encrypted, byte[] entropy)
        {
            return CryptoHelper.UnprotectData(encrypted, entropy);
        }

    }
}
