﻿using AutoMapper;
using Reactive.Bindings;
using System;
using System.Reactive.Linq;
using TestNarou3.Adaptor.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Translator.Converter
{
    internal class PointPerMinResolver
            : IValueResolver<BookmarkDetailListRow, BookmarkDetailListRowViewModel, ReadOnlyReactiveProperty<int>>
    {
        public ReadOnlyReactiveProperty<int> Resolve(
                BookmarkDetailListRow source, BookmarkDetailListRowViewModel destination,
                ReadOnlyReactiveProperty<int> destMember, ResolutionContext context)
        {
            return source.GlobalPoint.CombineLatest(source.Time, (point, time) => Convert(point, time)).ToReadOnlyReactiveProperty();
        }

        private static int Convert(int point, int time)
        {
            return (int)Math.Round((double)point / time, 0, MidpointRounding.AwayFromZero);
        }
    }
}
