﻿using NLog;
using Prism.Ioc;
using Prism.Modularity;
using Prism.Mvvm;
using Prism.Regions;
using TestNarou3.Adaptor;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Domain.Boundary.Repository;
using TestNarou3.OuterEdge.Repository.API;
using TestNarou3.OuterEdge.Repository.Setting;
using TestNarou3.OuterEdge.UI.View;

namespace TestNarou3.OuterEdge
{
    public class OuterEdgeModule : IModule
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public static readonly string ENSURE_STRONG_REFERRENCE = AdaptorModule.ENSURE_STRONG_REFERRENCE;

        public void RegisterTypes(IContainerRegistry containerRegistry)
        {
            ///
            /// Navigation Views
            ///

            containerRegistry.RegisterForNavigation<LoginFormPage, ILoginFormViewModel>();
            containerRegistry.RegisterForNavigation<BookmarkPage, IBookmarkViewModel>();

            containerRegistry.RegisterForNavigation<BookmarkCategoryView, IBookmarkCategoryViewModel>();
            containerRegistry.RegisterForNavigation<BookmarkDetailListView, IBookmarkDetailListViewModel>();

            ///
            /// Repositories
            ///

            containerRegistry.RegisterSingleton<IAppConfigRepository, AppConfigRepository>();
            containerRegistry.RegisterSingleton<INarouRepository, NarouRepository>();

            logger.Trace("RegisterTypes end");
        }

        public void OnInitialized(IContainerProvider containerProvider)
        {
#if false
            //
            // Views and ViewModels
            //

            ViewModelLocationProvider.Register<MainWindowView>(() => containerProvider.Resolve<IMainWindowViewModel>());

            ViewModelLocationProvider.Register<LoginFormPage>(() => containerProvider.Resolve<ILoginFormViewModel>());
            ViewModelLocationProvider.Register<BookmarkPage>(() => containerProvider.Resolve<IBookmarkViewModel>());

            ViewModelLocationProvider.Register<BookmarkCategoryView>(() => containerProvider.Resolve<IBookmarkCategoryViewModel>());
            ViewModelLocationProvider.Register<BookmarkDetailListView>(() => containerProvider.Resolve<IBookmarkDetailListViewModel>());
#endif

            //
            // Regions and Views
            //

            var rm = containerProvider.Resolve<IRegionManager>(); ;

            rm.RegisterViewWithRegion(IMainWindowViewModel.REGION_NAME, typeof(LoginFormPage));

            rm.RegisterViewWithRegion(IBookmarkViewModel.CATEGORY_REGION_NAME, typeof(BookmarkCategoryView));
            rm.RegisterViewWithRegion(IBookmarkViewModel.DETAIL_LIST_REGION_NAME, typeof(BookmarkDetailListView));

            logger.Trace("OnInitialized end");
        }
    }
}
