﻿using CleanAuLait.Core.Resource;
using NLog;
using Prism.Ioc;
using Prism.Modularity;
using TestNarou3.Infra.Boundary.Resource;
using TestNarou3.Infra.Core.Resource;

namespace TestNarou3.Infra
{
    public class InfraModule : IModule
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public void RegisterTypes(IContainerRegistry containerRegistry)
        {
            ///
            /// Resources
            ///

            containerRegistry.RegisterSingleton<IAppCaptionFormatter, AppCaptionFormatter>();

            containerRegistry.RegisterSingleton<IMessageRepository>(() => new MessageRepository(
                ResourceConst.MESSAGE_RESOURCE_NAME
            ));

            logger.Trace("RegisterTypes end");
        }

        public void OnInitialized(IContainerProvider containerProvider)
        {
        }
    }
}
