﻿using NLog;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using System;
using System.Reactive.Disposables;

namespace TestNarou3.Domain.Model.Entity.Child
{
    public partial record class BookmarkDetailListRow(
        string NCode,
        ReactivePropertySlim<string> Title,
        ReactivePropertySlim<string> Writer,
        ReactivePropertySlim<string> Story,
        ReactivePropertySlim<int> BigGenre,
        ReactivePropertySlim<int> Genre,
        ReactivePropertySlim<string> Keyword,
        ReactivePropertySlim<int> NovelType,
        ReactivePropertySlim<int> End,
        ReactivePropertySlim<int> GeneralAllNo,
        ReactivePropertySlim<int> Time,
        ReactivePropertySlim<int> IsStop,
        ReactivePropertySlim<int> IsR15,
        ReactivePropertySlim<int> IsBL,
        ReactivePropertySlim<int> IsGL,
        ReactivePropertySlim<int> IsZankoku,
        ReactivePropertySlim<int> IsTensei,
        ReactivePropertySlim<int> IsTenni,
        ReactivePropertySlim<int> GlobalPoint,
        ReactivePropertySlim<int> DailyPoint,
        ReactivePropertySlim<int> WeeklyPoint,
        ReactivePropertySlim<int> MonthlyPoint,
        ReactivePropertySlim<int> QuarterPoint,
        ReactivePropertySlim<int> YearlyPoint,
        ReactivePropertySlim<int> FavNovelCnt,
        ReactivePropertySlim<int> ImpressionCnt,
        ReactivePropertySlim<int> ReviewCnt,
        ReactivePropertySlim<int> AllPoint,
        ReactivePropertySlim<int> AllHyokaCnt,
        ReactivePropertySlim<string> GeneralFirstUp,
        ReactivePropertySlim<string> GeneralLastUp,
        ReactivePropertySlim<string> NovelUpdatedAt
    ) : IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public BookmarkDetailListRow(): this(
            NCode:          null,
            Title:          new(),
            Writer:         new(),
            Story:          new(),
            BigGenre:       new(),
            Genre:          new(),
            Keyword:        new(),
            NovelType:      new(),
            End:            new(),
            GeneralAllNo:   new(),
            Time:           new(),
            IsStop:         new(),
            IsR15:          new(),
            IsBL:           new(),
            IsGL:           new(),
            IsZankoku:      new(),
            IsTensei:       new(),
            IsTenni:        new(),
            GlobalPoint:    new(),
            DailyPoint:     new(),
            WeeklyPoint:    new(),
            MonthlyPoint:   new(),
            QuarterPoint:   new(),
            YearlyPoint:    new(),
            FavNovelCnt:    new(),
            ImpressionCnt:  new(),
            ReviewCnt:      new(),
            AllPoint:       new(),
            AllHyokaCnt:    new(),
            GeneralFirstUp: new(),
            GeneralLastUp:  new(),
            NovelUpdatedAt: new()
        )
        {
            this.Title.AddTo(this.disposables);
            this.Writer.AddTo(this.disposables);
            this.Story.AddTo(this.disposables);
            this.BigGenre.AddTo(this.disposables);
            this.Genre.AddTo(this.disposables);
            this.Keyword.AddTo(this.disposables);
            this.NovelType.AddTo(this.disposables);
            this.End.AddTo(this.disposables);
            this.GeneralAllNo.AddTo(this.disposables);
            this.Time.AddTo(this.disposables);
            this.IsStop.AddTo(this.disposables);
            this.IsR15.AddTo(this.disposables);
            this.IsBL.AddTo(this.disposables);
            this.IsGL.AddTo(this.disposables);
            this.IsZankoku.AddTo(this.disposables);
            this.IsTensei.AddTo(this.disposables);
            this.GlobalPoint.AddTo(this.disposables);
            this.DailyPoint.AddTo(this.disposables);
            this.WeeklyPoint.AddTo(this.disposables);
            this.MonthlyPoint.AddTo(this.disposables);
            this.QuarterPoint.AddTo(this.disposables);
            this.YearlyPoint.AddTo(this.disposables);
            this.FavNovelCnt.AddTo(this.disposables);
            this.ImpressionCnt.AddTo(this.disposables);
            this.ReviewCnt.AddTo(this.disposables);
            this.AllPoint.AddTo(this.disposables);
            this.AllHyokaCnt.AddTo(this.disposables);
            this.GeneralFirstUp.AddTo(this.disposables);
            this.GeneralLastUp.AddTo(this.disposables);
            this.NovelUpdatedAt.AddTo(this.disposables);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();
                    logger.Trace("BookmarkDetailListRow[{0}] disposed.", NCode);
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            // このコードを変更しないでください。クリーンアップ コードを 'Dispose(bool disposing)' メソッドに記述します
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
