﻿using NLog;
using Prism.Navigation;
using Prism.Regions;
using Reactive.Bindings;
using Reactive.Bindings.Extensions;
using System.Reactive.Disposables;
using TestNarou3.Adaptor.Boundary.Controller;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel;
using TestNarou3.Infra.Boundary.Resource;
using TestNarou3.UseCase.Request;

namespace TestNarou3.Adaptor.Gateway.ViewModel
{
    internal class MainWindowViewModel : IMainWindowViewModel, IDestructible, IDisposable
    {
        private static readonly ILogger logger = LogManager.GetCurrentClassLogger();

        public ReactiveProperty<string> Title { get; }

        private readonly IAppWindowController wc;
        private readonly IRegionManager rm;

        private readonly CompositeDisposable disposables = new();
        private bool disposedValue;

        public MainWindowViewModel(
                IAppCaptionFormatter caption,
                IAppWindowController wc,
                IRegionManager rm)
        {
            this.wc = wc;
            this.rm = rm;

            this.Title = new ReactiveProperty<string>(caption.GetCaption()).AddTo(disposables);
        }

        public void OnClosing()
        {
            _ = this.wc.Execute(new NarouLogoutRequest());
            _ = this.wc.Execute(new AppConfigSaveRequest());

            this.Dispose();
        }

        #region IDestructible, IDisposable

        public void Destroy()
        {
            this.Dispose();
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    this.disposables.Dispose();

                    logger.Trace("MainWindowViewModel disposed.");

                    foreach (IRegion region in rm.Regions)
                    {
                        region.RemoveAll();
                    }
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
        #endregion

    }
}
