﻿using CleanAuLait.ObservableCollectionsMod;
using Reactive.Bindings;
using TestNarou3.Adaptor.Boundary.Gateway.ViewModel.Child;
using TestNarou3.Domain.Model.Entity;
using TestNarou3.Domain.Model.Entity.Child;

namespace TestNarou3.Adaptor.Boundary.Gateway.ViewModel
{
    public interface IBookmarkDetailListViewModel
    {
        public static readonly string SUMMARY_LABEL = "●";

        internal const string CATEGORY_NO_KEY = "CATEGORY_NO";

        internal static readonly Uri URI = new("BookmarkDetailListView", UriKind.Relative);

        ReactiveProperty<IBookmarkDetailListRowViewModel> SelectedItem { get; }
        INotifyCollectionChangedListSynchronizedSingleView<BookmarkDetailListRow, IBookmarkDetailListRowViewModel> Rows { get; }

        ReactiveCommand CommandOpenBookmark { get; }
        BookmarkDetailList Source { get; }

        void SynchronizeWith(BookmarkDetailList list);

        void SortByValueColumn<TValueColumn>(string tag, Func<BookmarkDetailListRow, TValueColumn> selector, bool asceding);
        void SortByViewColumn<TViewColumn>(string tag, Func<IBookmarkDetailListRowViewModel, TViewColumn> selector, bool asceding);
    }
}
