//******************************************************************************
//
// MIDITrail / MTGridBoxMod
//
// Obh{bNX`ModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTGridBoxMod.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTGridBoxMod::MTGridBoxMod(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTGridBoxMod::~MTGridBoxMod(void)
{
}

//******************************************************************************
// ړ
//******************************************************************************
int MTGridBoxMod::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;

	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);

	if(rollAngle < 0.0f) {
		rollAngle += 360.0f;
	}

	if((rollAngle > 120.0f) && (rollAngle < 300.0f)) {
		rollAngle -= 180.0f;
	}

	//]s
	D3DXMatrixRotationX(&rotateMatrix, D3DXToRadian(rollAngle));

	//ړs
	moveVector = m_NoteDesign.GetWorldMoveVector();
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);

	//s̍
	D3DXMatrixMultiply(&worldMatrix, &rotateMatrix, &moveMatrix);

	//ϊsݒ
	m_Primitive.Transform(worldMatrix);

	return result;
}
