//******************************************************************************
//
// MIDITrail / MTScenePianoRoll3DMod
//
// sAm[3DV[`ModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "stdafx.h"
#include "YNBaseLib.h"
#include "MTScenePianoRoll3DMod.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTScenePianoRoll3DMod::MTScenePianoRoll3DMod()
{
	m_IsSingleKeyboard = false;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTScenePianoRoll3DMod::~MTScenePianoRoll3DMod()
{
	Release();
}

//******************************************************************************
// V[
//******************************************************************************
int MTScenePianoRoll3DMod::Create(
		HWND hWnd,
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	Release();

	//NX̃V[Ăяo
	result = MTScenePianoRoll3D::Create(hWnd, pD3DDevice, pSeqData);
	if (result != 0) goto EXIT;

	//----------------------------------
	// Cg2
	//----------------------------------
	//Cg2
	result = m_DirLightBack.Initialize();
	if (result != 0) goto EXIT;

	//Cg2F
	_SetLightColor(&m_DirLightBack);

	//Cg2
	m_DirLightBack.SetDirection(D3DXVECTOR3(-1.0f, 1.0f, -2.0f));

	//Cg̃foCXo^
	result = m_DirLightBack.SetDevice(pD3DDevice, 1, m_IsEnableLight);
	if (result != 0) goto EXIT;

	//----------------------------------
	// `IuWFNg
	//----------------------------------

	//Obh{bNX
	result = m_GridBoxMod.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;
	
	//m[g{bNX
	result = m_NoteBoxMod.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//m[gg䐶
	result = m_NoteRippleMod.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//m[g̎
	result = m_NoteLyrics.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend);
	if (result != 0) goto EXIT;

	//^CCWP[^
	result = m_TimeIndicatorMod.Create(pD3DDevice, GetName(), pSeqData);
	if (result != 0) goto EXIT;

	//sN`{[h
	m_PictBoard.SetEnable(false);

	//sAmL[{[h
	result = m_PianoKeyboardCtrlMod.Create(pD3DDevice, GetName(), pSeqData, &m_NotePitchBend, m_IsSingleKeyboard);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTScenePianoRoll3DMod::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	float rollAngle = 0.0f;
	D3DXVECTOR3 camVector;

	//NX̕ϊĂяo
	result = MTScenePianoRoll3D::Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//JW擾
	m_FirstPersonCam.GetPosition(&camVector);

	//]px擾
	rollAngle = m_FirstPersonCam.GetManualRollAngle();

	//Obh{bNXXV
	result = m_GridBoxMod.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;

	//m[g{bNXXV
	result = m_NoteBoxMod.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;

	//^CCWP[^XV
	result = m_TimeIndicatorMod.Transform(pD3DDevice, camVector, rollAngle);
	if (result != 0) goto EXIT;

	//m[ggXV
	result = m_NoteRippleMod.Transform(pD3DDevice, camVector, rollAngle);
	if (result != 0) goto EXIT;

	//m[g̎XV
	result = m_NoteLyrics.Transform(pD3DDevice, camVector, rollAngle);
	if (result != 0) goto EXIT;

	//sAmL[{[hXV
	result = m_PianoKeyboardCtrlMod.Transform(pD3DDevice, rollAngle);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTScenePianoRoll3DMod::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	D3DXVECTOR3 camVector;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//XV
	result = Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//JW擾
	m_FirstPersonCam.GetPosition(&camVector);

	//wi摜`
	result = m_BackgroundImage.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//`
	result = m_Stars.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//Obh{bNX`
	result = m_GridBoxMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	//m[g{bNX`
	result = m_NoteBoxMod.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

	// JʒutʒuOł
	if(m_TimeIndicatorMod.GetPos() > camVector.x) {

		//bV^CCWP[^̎g䁄L[{[h̏ŉ`

		//bV`
		result = m_MeshCtrl.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//^CCWP[^`
		result = m_TimeIndicatorMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//m[g̎`
		result = m_NoteLyrics.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//m[gg`
		result = m_NoteRippleMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//sAmL[{[h`
		result = m_PianoKeyboardCtrlMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

	} else {

		//L[{[hg䁄̎^CCWP[^bV̏ŉ`

		//sAmL[{[h`
		result = m_PianoKeyboardCtrlMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//m[gg`
		result = m_NoteRippleMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//m[g̎`
		result = m_NoteLyrics.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//^CCWP[^`
		result = m_TimeIndicatorMod.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

		//bV`
		result = m_MeshCtrl.Draw(pD3DDevice);
		if (result != 0) goto EXIT;

	}

	//_bV{[h`FWϊςݒ_p邽߈ԍŌɕ`悷
	result = m_Dashboard.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTScenePianoRoll3DMod::Release()
{
	m_NoteBoxMod.Release();
	m_NoteRippleMod.Release();
	m_NoteLyrics.Release();
	m_PianoKeyboardCtrlMod.Release();

	MTScenePianoRoll3D::Release();
}

//******************************************************************************
// V[PTbZ[WM
//******************************************************************************
int MTScenePianoRoll3DMod::OnRecvSequencerMsg(
		unsigned long param1,
		unsigned long param2
	)
{
	int result = 0;
	SMMsgParser parser;

	parser.Parse(param1, param2);

	//tԒʒm
	if (parser.GetMsg() == SMMsgParser::MsgPlayStatus) {
		if (parser.GetPlayStatus() == SMMsgParser::StatusStop) {
			//~iIj
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPlay) {
			//t
		}
		else if (parser.GetPlayStatus() == SMMsgParser::StatusPause) {
			//ꎞ~
		}
	}
	//t`bN^Cʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPlayTime) {
		m_Dashboard.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_FirstPersonCam.SetCurTickTime(parser.GetPlayTickTime());
		// Viewpoint̓ǂݏɎxႪôŁAm_TimeIndicator ɂʒm
		m_TimeIndicator.SetCurTickTime(parser.GetPlayTickTime());
		m_TimeIndicatorMod.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteRippleMod.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_NoteRippleMod.SetCurTickTime(parser.GetPlayTickTime());
		m_PictBoard.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteBoxMod.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_NoteBoxMod.SetCurTickTime(parser.GetPlayTickTime());
		m_NoteLyrics.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_NoteLyrics.SetCurTickTime(parser.GetPlayTickTime());
		m_PianoKeyboardCtrlMod.SetPlayTimeMSec(parser.GetPlayTimeMSec());
		m_PianoKeyboardCtrlMod.SetCurTickTime(parser.GetPlayTickTime());
	}
	//e|ύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgTempo) {
		m_Dashboard.SetTempoBPM(parser.GetTempoBPM());
	}
	//ߔԍʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBar) {
		m_Dashboard.SetBarNo(parser.GetBarNo());
	}
	//qLύXʒm
	else if (parser.GetMsg() == SMMsgParser::MsgBeat) {
		m_Dashboard.SetBeat(parser.GetBeatNumerator(), parser.GetBeatDenominator());
	}
	//m[gOFFʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOff) {
		// NOP
	}
	//m[gONʒm
	else if (parser.GetMsg() == SMMsgParser::MsgNoteOn) {
		m_Dashboard.SetNoteOn();
	}
	//sb`xhʒm
	else if (parser.GetMsg() == SMMsgParser::MsgPitchBend) {
		m_NotePitchBend.SetPitchBend(parser.GetPortNo(), parser.GetChNo(), parser.GetPitchBendValue(), parser.GetPitchBendSensitivity());
	}
	//XLbvJnʒm
	else if (parser.GetMsg() == SMMsgParser::MsgSkipStart) {
		if (parser.GetSkipStartDirection() == SMMsgParser::SkipBack) {
			m_NotePitchBend.Reset();
		}
		m_NoteBoxMod.Reset();
		m_NoteBoxMod.SetSkipStatus(true);
		m_NoteRippleMod.Reset();
		m_NoteRippleMod.SetSkipStatus(true);
		m_NoteLyrics.Reset();
		m_NoteLyrics.SetSkipStatus(true);
		m_PianoKeyboardCtrlMod.Reset();
		m_PianoKeyboardCtrlMod.SetSkipStatus(true);
		m_IsSkipping = true;
	}
	//XLbvIʒm
	else if (parser.GetMsg() == SMMsgParser::MsgSkipEnd) {
		m_Dashboard.SetNotesCount(parser.GetSkipEndNotesCount());
		m_NoteBoxMod.SetSkipStatus(false);
		m_NoteRippleMod.SetSkipStatus(false);
		m_NoteLyrics.SetSkipStatus(false);
		m_PianoKeyboardCtrlMod.SetSkipStatus(false);
		m_IsSkipping = false;
	}

//EXIT:;
	return result;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTScenePianoRoll3DMod::_Reset()
{
	MTScenePianoRoll3D::_Reset();

	m_TimeIndicatorMod.Reset();
	m_NoteBoxMod.Reset();
	m_NoteRippleMod.Reset();
	m_NoteLyrics.Reset();
	m_PianoKeyboardCtrlMod.Reset();
}

//******************************************************************************
// \ʐݒ
//******************************************************************************
void MTScenePianoRoll3DMod::SetEffect(
		MTScene::EffectType type,
		bool isEnable
	)
{
	switch (type) {
		case EffectPianoKeyboard:
			m_PianoKeyboardCtrlMod.SetEnable(isEnable);
			break;
		case EffectRipple:
			m_NoteRippleMod.SetEnable(isEnable);
			m_NoteLyrics.SetEnable(isEnable);
			break;
		case EffectTimeIndicator:
			m_TimeIndicatorMod.SetEnable(isEnable);
			break;
		case EffectGridBox:
			m_GridBoxMod.SetEnable(isEnable);
			break;
		default:
			MTScenePianoRoll3D::SetEffect(type, isEnable);
			break;
	}

	return;
}
