//******************************************************************************
//
// MIDITrail / MTPianoKeyboardCtrlMod
//
// sAmL[{[hModNX
//
// Copyright (C) 2012 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTPianoKeyboardCtrl.h"
#include "MTPianoKeyboardDesignMod.h"
#include "MTNoteDesignMod.h"


//******************************************************************************
// sAmL[{[hModNX
//******************************************************************************
class MTPianoKeyboardCtrlMod : public MTPianoKeyboardCtrl
{
public:

	//RXgN^^fXgN^
	MTPianoKeyboardCtrlMod(void);
	virtual ~MTPianoKeyboardCtrlMod(void);

	//
	virtual int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend,
			bool isSingleKeyboard
		);

	//XV
	virtual int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);

	//`
	virtual int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//Zbg
	virtual void Reset();

protected:

	virtual int _CreateKeyboards(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData);

private:

	//m[gfUC
	MTNoteDesignMod m_NoteDesignMod;

	//L[{[hfUC
	MTPianoKeyboardDesignMod m_KeyboardDesignMod;

	//|[gXg
	SMPortList m_PortList;

	//ANeBu|[gtO
	bool m_isActivePort[SM_MAX_PORT_NUM];

	//L[{[hCfbNX
	int m_KeyboardIndex[SM_MAX_PORT_NUM];
	unsigned char m_MaxKeyboardIndex;

	//L[z
	float m_KeyDownRateMod[SM_MAX_CH_NUM][SM_MAX_CH_NUM][SM_MAX_NOTE_NUM];

	virtual int _UpdateNoteStatus(
				unsigned long playTimeMSec,
				unsigned long keyDownDuration,
				unsigned long keyUpDuration,
				SMNote note,
				NoteStatus* pNoteStatus
			);
	virtual int _UpdateVertexOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);

	int _GetKeyboardIndexFromNote(const SMNote &note);

	float GetMaxPitchBendShift(unsigned char portNo);
};


