//******************************************************************************
//
// MIDITrail / MTNoteDesignRingMod
//
// m[gfUCOModNX
//
// Copyright (C) 2019 Yossiepon Oniichan. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "MTNoteDesignRingMod.h"
#include "DXH.h"


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteDesignRingMod::MTNoteDesignRingMod(void)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteDesignRingMod::~MTNoteDesignRingMod(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int MTNoteDesignRingMod::Initialize(
	const TCHAR* pSceneName,
	SMSeqData* pSeqData
)
{
	int result = 0;

	result = MTNoteDesignRing::Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

	result = MTNoteDesignMod::Initialize(pSceneName, pSeqData);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// m[g{bNXSW擾
//******************************************************************************
D3DXVECTOR3 MTNoteDesignRingMod::GetNoteBoxCenterPosX(
	unsigned long curTickTime,
	unsigned char portNo,
	unsigned char chNo,
	unsigned char noteNo,
	short pitchBendValue,				//ȗFsb`xh
	unsigned char pitchBendSensitivity	//ȗFsb`xhx
)
{
	return MTNoteDesignRing::GetNoteBoxCenterPosX(curTickTime, portNo, chNo, noteNo, pitchBendValue, pitchBendSensitivity);
}

//******************************************************************************
// m[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRingMod::GetNoteBoxVirtexPos(
	unsigned long curTickTime,
	unsigned char portNo,
	unsigned char chNo,
	unsigned char noteNo,
	D3DXVECTOR3* pVector0,	//YZ+Xč
	D3DXVECTOR3* pVector1,	//YZ+XĉE
	D3DXVECTOR3* pVector2,	//YZ+Xč
	D3DXVECTOR3* pVector3,	//YZ+XĉE
	short pitchBendValue,				//ȗFsb`xh
	unsigned char pitchBendSensitivity	//ȗFsb`xhx

)
{
	MTNoteDesignRing::GetNoteBoxVirtexPos(
			curTickTime, portNo, chNo, noteNo, pVector0, pVector1, pVector2, pVector3, pitchBendValue, pitchBendSensitivity);
}

//******************************************************************************
// m[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRingMod::GetActiveNoteBoxVirtexPos(
	unsigned long curTickTime,
	unsigned char portNo,
	unsigned char chNo,
	unsigned char noteNo,
	D3DXVECTOR3* pVector0,	//YZ+Xč
	D3DXVECTOR3* pVector1,	//YZ+XĉE
	D3DXVECTOR3* pVector2,	//YZ+Xč
	D3DXVECTOR3* pVector3,	//YZ+XĉE
	short pitchBendValue,				//ȗFsb`xh
	unsigned char pitchBendSensitivity,	//ȗFsb`xhx
	unsigned long elapsedTime			//ȗFoߎԁi~bj
)
{
	MTNoteDesignRing::GetActiveNoteBoxVirtexPos(
			curTickTime, portNo, chNo, noteNo, pVector0, pVector1, pVector2, pVector3, pitchBendValue, pitchBendSensitivity, elapsedTime);
}

//******************************************************************************
// m[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRingMod::GetActiveNoteBoxVirtexPos(
	unsigned long curTickTime,
	unsigned char portNo,
	unsigned char chNo,
	unsigned char noteNo,
	D3DXVECTOR3* pVector0,	//YZ+Xč
	D3DXVECTOR3* pVector1,	//YZ+XĉE
	D3DXVECTOR3* pVector2,	//YZ+Xč
	D3DXVECTOR3* pVector3,	//YZ+XĉE
	short pitchBendValue,				//ȗFsb`xh
	unsigned char pitchBendSensitivity,	//ȗFsb`xhx
	float rate							//ȗFTCY䗦
)
{
	D3DXVECTOR3 basePos0;
	D3DXVECTOR3 basePos1;
	D3DXVECTOR3 basePos2;
	float angle0 = 0.0f;
	float angle1 = 0.0f;
	float angle2 = 0.0f;
	float curSizeRatio = 1.0f;

	if (rate > 0.0f) {
		curSizeRatio = 1.0f + (MTNoteDesignMod::m_ActiveNoteBoxSizeRatio - 1.0f) * GetDecayCoefficient(rate, 30.0f);
	}

	//m[gW
	basePos0 = _GetNoteBasePos(curTickTime, portNo, chNo);
	basePos1 = basePos0;
	basePos1.y -= MTNoteDesignMod::GetNoteBoxWidth() * curSizeRatio / 2.0f;
	basePos2 = basePos0;
	basePos2.y += MTNoteDesignMod::GetNoteBoxWidth() * curSizeRatio / 2.0f;

	//m[gԍŊpx
	angle0 = _GetNoteAngle(noteNo, pitchBendValue, pitchBendSensitivity);
	angle1 = angle0 - (m_NoteAngleStep * curSizeRatio / 2.0f);
	angle2 = angle0 + (m_NoteAngleStep * curSizeRatio / 2.0f);

	*pVector0 = DXH::RotateYZ(0.0f, 0.0f, basePos2, angle1);
	*pVector1 = DXH::RotateYZ(0.0f, 0.0f, basePos2, angle2);
	*pVector2 = DXH::RotateYZ(0.0f, 0.0f, basePos1, angle1);
	*pVector3 = DXH::RotateYZ(0.0f, 0.0f, basePos1, angle2);
}

//******************************************************************************
// Cuj^pm[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRingMod::GetNoteBoxVirtexPosLive(
	unsigned long elapsedTime,
	unsigned char portNo,
	unsigned char chNo,
	unsigned char noteNo,
	D3DXVECTOR3* pVector0,	//YZ+Xč
	D3DXVECTOR3* pVector1,	//YZ+XĉE
	D3DXVECTOR3* pVector2,	//YZ+Xč
	D3DXVECTOR3* pVector3,	//YZ+XĉE
	short pitchBendValue,				//ȗFsb`xh
	unsigned char pitchBendSensitivity	//ȗFsb`xhx
)
{
	MTNoteDesignRing::GetNoteBoxVirtexPosLive(
		elapsedTime, portNo, chNo, noteNo, pVector0, pVector1, pVector2, pVector3, pitchBendValue, pitchBendSensitivity);
}

//******************************************************************************
// |[g_YW擾
//******************************************************************************
float MTNoteDesignRingMod::GetPortOriginY(
	unsigned char portNo
)
{
	return MTNoteDesignRing::GetPortOriginY(portNo);
}

//******************************************************************************
// |[g_ZW擾
//******************************************************************************
float MTNoteDesignRingMod::GetPortOriginZ(
	unsigned char portNo
)
{
	return MTNoteDesignRing::GetPortOriginZ(portNo);
}

//******************************************************************************
// EWzuړxNg擾
//******************************************************************************
D3DXVECTOR3 MTNoteDesignRingMod::GetWorldMoveVector()
{
	return MTNoteDesignRing::GetWorldMoveVector();
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTNoteDesignRingMod::_LoadConfFile(
	const TCHAR* pSceneName
)
{
	int result = 0;

	result = MTNoteDesignRing::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	result = MTNoteDesignMod::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}


