//******************************************************************************
//
// MIDITrail / MTNoteDesignRing
//
// m[gfUCONX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
// m[gfUCNX
//******************************************************************************
class MTNoteDesignRing : public MTNoteDesign
{
public:

	//RXgN^^fXgN^
	MTNoteDesignRing(void);
	virtual ~MTNoteDesignRing(void);

	//Cuj^[hݒ
	void SetLiveMode(void);

	//m[g{bNXSW擾
	virtual D3DXVECTOR3 GetNoteBoxCenterPosX(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//m[g{bNX_W擾
	virtual void GetNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//m[g{bNX_W擾
	virtual void GetActiveNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0,	//ȗFsb`xhx
				unsigned long elapsedTime = 0            //ȗFoߎԁi~bj
			);

	//Cuj^pm[g{bNX_W擾
	virtual void GetNoteBoxVirtexPosLive(
				unsigned long elapsedTime,	//oߎԁi~bj
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//ObhOW擾
	void GetGridRingBasePos(
			unsigned long totalTickTime,
			D3DXVECTOR3* pBasePosStart,
			D3DXVECTOR3* pBasePosEnd
		);

	//Cuj^pObhOW擾
	void GetGridRingBasePosLive(
			D3DXVECTOR3* pBasePosStart,
			D3DXVECTOR3* pBasePosEnd
		);

	//|[g_W擾
	virtual float GetPortOriginY(unsigned char portNo);
	virtual float GetPortOriginZ(unsigned char portNo);

	//EWzuړxNg擾
	virtual D3DXVECTOR3 GetWorldMoveVector();

// >>> modify access level to proteced 20191224 yossiepon begin
protected:
// <<< modify access level to proteced 20191224 yossiepon end

	bool m_isLiveMode;
	float m_NoteAngleStep;
	float m_RingRadius;

	// m[gW擾
	D3DXVECTOR3 _GetNoteBasePos(
			unsigned long curTickTime,
			unsigned char portNo,
			unsigned char chNo
		);

	// m[gpx擾
	float _GetNoteAngle(
			unsigned char noteNo,
			short pitchBendValue,				//ȗFsb`xh
			unsigned char pitchBendSensitivity	//ȗFsb`xhx
		);

	virtual int _LoadConfFile(const TCHAR* pSceneName);

};


