//******************************************************************************
//
// MIDITrail / MTPianoKeyboardDesign
//
// sAmL[{[hfUCNX
//
// Copyright (C) 2010-2013 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// L[{[h̊{zuW
//
//  +y   +z
//  |    /
//  |   / +-#-#-+-#-#-#-+------
//  |  / / # # / # # # / ...
//  | / / / / / / / / / ...
//  |/ +-+-+-+-+-+-+-+------
// 0+------------------------ +x

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// sAmL[{[hfUCNX
//******************************************************************************
class MTPianoKeyboardDesign
{
public:

	//L[
	//  ͔Ɣ̒SɂĔzuĂ
	//  ̂ߔ̌`CB܂łׂĈقȂ
	enum KeyType {
		KeyWhiteC,	//C
		KeyWhiteD,	//D
		KeyWhiteE,	//E
		KeyWhiteF,	//F
		KeyWhiteG,	//G
		KeyWhiteA,	//A
		KeyWhiteB,	//B
		KeyBlack	//
	};

	//L[F
	enum ActiveKeyColorType {
		DefaultColor,	//ftHgF
		NoteColor		//m[gF
	};

public:

	MTPianoKeyboardDesign(void);
	virtual ~MTPianoKeyboardDesign(void);

	//
// >>> modify 20120728 yossiepon begin
	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);
// <<< modify 20120728 yossiepon end

	//|[g_W擾
	float GetPortOriginX(unsigned char portNo);
	float GetPortOriginY(unsigned char portNo);
	float GetPortOriginZ(unsigned char portNo);

	//L[ʎ擾
	KeyType GetKeyType(unsigned char noteNo);

	//L[SXW擾
	float GetKeyCenterPosX(unsigned char noteNo);

	//zuԊu擾
	float GetWhiteKeyStep();

	//TCY擾
	float GetWhiteKeyWidth();

	//擾
	float GetWhiteKeyHeight();

	//擾
	float GetWhiteKeyLen();

	//TCY擾
	float GetBlackKeyWidth();

	//擾
	float GetBlackKeyHeight();

	//XΒ擾
	float GetBlackKeySlopeLen();

	//擾
	float GetBlackKeyLen();

	//L[ԊuTCY擾
	float GetKeySpaceSize();

	//L[]SYW擾
	float GetKeyRotateAxisXPos();

	//L[]px
	float GetKeyRotateAngle();

	//L[~Ԏ擾(msec)
	unsigned long GetKeyDownDuration();

	//L[㏸Ԏ擾(msec)
	unsigned long GetKeyUpDuration();

	//sb`xhL[{[hVtgʎ擾
	float GetPitchBendShift(short pitchBendValue, unsigned char pitchBendSensitivity);

	//m[ghbvW擾
	float GetNoteDropPosZ(unsigned char noteNo);

	//J[擾
	D3DXCOLOR GetWhiteKeyColor();

	//J[擾
	D3DXCOLOR GetBlackKeyColor();

	//L[J[擾
	D3DXCOLOR GetActiveKeyColor(
			unsigned char noteNo,
			unsigned long elapsedTime,
			D3DXCOLOR* pNoteColor = NULL
		);

	//eNX`W擾
	void GetWhiteKeyTexturePosTop(
			unsigned char noteNo,
			D3DXVECTOR2* pTexPos0,
			D3DXVECTOR2* pTexPos1,
			D3DXVECTOR2* pTexPos2,
			D3DXVECTOR2* pTexPos3,
			D3DXVECTOR2* pTexPos4,
			D3DXVECTOR2* pTexPos5,
			D3DXVECTOR2* pTexPos6,
			D3DXVECTOR2* pTexPos7
		);
	void GetWhiteKeyTexturePosFront(
			unsigned char noteNo,
			D3DXVECTOR2* pTexPos0,
			D3DXVECTOR2* pTexPos1,
			D3DXVECTOR2* pTexPos2,
			D3DXVECTOR2* pTexPos3
		);
	void GetWhiteKeyTexturePosSingleColor(
			unsigned char noteNo,
			D3DXVECTOR2* pTexPos
		);

	//eNX`W擾
	void GetBlackKeyTexturePos(
			unsigned char noteNo,
			D3DXVECTOR2* pTexPos0,
			D3DXVECTOR2* pTexPos1,
			D3DXVECTOR2* pTexPos2,
			D3DXVECTOR2* pTexPos3,
			D3DXVECTOR2* pTexPos4,
			D3DXVECTOR2* pTexPos5,
			D3DXVECTOR2* pTexPos6,
			D3DXVECTOR2* pTexPos7,
			D3DXVECTOR2* pTexPos8,
			D3DXVECTOR2* pTexPos9,
			bool isColored = false
		);
	void GetBlackKeyTexturePosSingleColor(
			unsigned char noteNo,
			D3DXVECTOR2* pTexPos,
			bool isColored = false
		);

	//L[{[hW擾
	D3DXVECTOR3 GetKeyboardBasePos(unsigned char portNo, unsigned char chNo);

	//L[{[hő\擾
	unsigned long GetKeyboardMaxDispNum();

	//L[\͈͎擾
	unsigned char GetKeyDispRangeStart();
	unsigned char GetKeyDispRangeEnd();
	bool IsKeyDisp(unsigned char noteNo);

private:

	//L[
	typedef struct {
		KeyType keyType;
		float keyCenterPosX;
	} MTKeyInfo;

private:

	//L[z
	MTKeyInfo m_KeyInfo[SM_MAX_NOTE_NUM];

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	//|[g
	SMPortList m_PortList;
	unsigned char m_PortIndex[SM_MAX_PORT_NUM];

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	//XP[
	float m_WhiteKeyStep;
	float m_WhiteKeyWidth;
	float m_WhiteKeyHeight;
	float m_WhiteKeyLen;
	float m_BlackKeyWidth;
	float m_BlackKeyHeight;
	float m_BlackKeySlopeLen;
	float m_BlackKeyLen;
	float m_KeySpaceSize;
	float m_NoteDropPosZ4WhiteKey;
	float m_NoteDropPosZ4BlackKey;
	float m_BlackKeyShiftCDE;
	float m_BlackKeyShiftFGAB;

	//L[]
	float m_KeyRotateAxisXPos;
	float m_KeyRotateAngle;
	int m_KeyDownDuration;
	int m_KeyUpDuration;

	//L[{[hzu

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	float m_KeyboardStepY;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	float m_KeyboardStepZ;
	int m_KeyboardMaxDispNum;

	//L[F
	D3DXCOLOR m_WhiteKeyColor;
	D3DXCOLOR m_BlackKeyColor;

	//L[F
	D3DXCOLOR m_ActiveKeyColor;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	int m_ActiveKeyColorDuration;
	float m_ActiveKeyColorTailRate;
	ActiveKeyColorType m_ActiveKeyColorType;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	//L[\͈
	int m_KeyDispRangeStart;
	int m_KeyDispRangeEnd;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	void _Initialize();

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	void _InitKeyType();
	void _InitKeyPos();

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	int _LoadConfFile(const TCHAR* pSceneName);
};


