//******************************************************************************
//
// MIDITrail / MTNoteDesign
//
// m[gfUCNX
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// m[g{bNX̐ʂ0-1-2-3̎lpƂB
// ̎lp̒SW_łA|[g^`l^m[g̔ԍ
// ɂČ肳B
//
//           +--+
//          /  /|
//         /  / +
//        /  / /      +x
//       /  / /      /
//     0+--+1/ +y   /
//      |  |/   |  /
//     2+--+3   | /
//              |/
//   +z---------+0
//

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"

using namespace SMIDILib;


//******************************************************************************
// m[gfUCNX
//******************************************************************************
class MTNoteDesign
{
public:

	//RXgN^^fXgN^
	MTNoteDesign(void);
	virtual ~MTNoteDesign(void);

	//
// >>> modify 20161225 yossiepon begin
	virtual int Initialize(const TCHAR* pSceneName, SMSeqData* pSeqData);
// <<< modify 20161225 yossiepon end

	//tʒu擾
	float GetPlayPosX(unsigned long curTickTime);

	//Cuj^pm[gʒu擾
	float GetLivePosX(unsigned long elapsedTime);

	//m[g{bNXSW擾
	D3DXVECTOR3 GetNoteBoxCenterPosX(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//m[g{bNXcTCY擾
	float GetNoteBoxHeight();
	float GetNoteBoxWidht();

	//m[gԊu擾
	float GetNoteStep();

	//`lԊu擾
	float GetChStep();

	//Cuj^\
	unsigned long GetLiveMonitorDisplayDuration();

	//m[g{bNX_W擾
	void GetNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//m[g{bNX_W擾
	void GetActiveNoteBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0,	//ȗFsb`xhx
				unsigned long elapsedTime = 0			//ȗFoߎԁi~bj
			);

	//Cuj^pm[g{bNX_W擾
	void GetNoteBoxVirtexPosLive(
				unsigned long elapsedTime,	//oߎԁi~bj
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3,	//YZ+XĉE
				short pitchBendValue = 0,				//ȗFsb`xh
				unsigned char pitchBendSensitivity = 0	//ȗFsb`xhx
			);

	//Obh{bNX_W擾
	void GetGridBoxVirtexPos(
				unsigned long curTickTime,
				unsigned char portNo,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3 	//YZ+XĉE
			);

	//Cuj^pObh{bNX_W擾
	void GetGridBoxVirtexPosLive(
				unsigned long elapsedTime,	//oߎԁi~bj
				unsigned char portNo,	//|[gԍ
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3 	//YZ+XĉE
			);

	//Đʒ_W擾
	void GetPlaybackSectionVirtexPos(
				unsigned long curTickTime,
				D3DXVECTOR3* pVector0,	//YZ+Xč
				D3DXVECTOR3* pVector1,	//YZ+XĉE
				D3DXVECTOR3* pVector2,	//YZ+Xč
				D3DXVECTOR3* pVector3 	//YZ+XĉE
			);

	//gTCY擾Foߎԁi~bj͏ȗ
	float GetRippleHeight(unsigned long elapsedTime = 0);
	float GetRippleWidth(unsigned long elapsedTime = 0);
	float GetRippleAlpha(unsigned long elapsedTime = 0);

	//sN`{[hΈʒu擾
	float GetPictBoardRelativePos();

	//|[g_W擾
	float GetPortOriginY(unsigned char portNo);
	float GetPortOriginZ(unsigned char portNo);

	//EWzuړxNg擾
	D3DXVECTOR3 GetWorldMoveVector();

	//m[g{bNXJ[擾
	D3DXCOLOR GetNoteBoxColor(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo
			);

	//m[g{bNXJ[擾
	D3DXCOLOR GetActiveNoteBoxColor(
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				unsigned long elapsedTime
			);

	//m[g{bNXG~bVu擾i}eApj
	D3DXCOLOR GetActiveNoteEmissive();

	//ObhCJ[擾
	D3DXCOLOR GetGridLineColor();

	//ĐʃJ[擾
	D3DXCOLOR GetPlaybackSectionColor();

private:

	enum NoteColorType {
		Channel,
		Scale
	};

	unsigned long m_TimeDivision;
	float m_QuarterNoteLength;
	float m_NoteBoxHeight;
	float m_NoteBoxWidth;
	float m_NoteStep;
	float m_ChStep;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	float m_RippleHeight;
	float m_RippleWidth;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	float m_PictBoardRelativePos;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	SMPortList m_PortList;
	unsigned char m_PortIndex[256];

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	NoteColorType m_NoteColorType;
	D3DXCOLOR m_NoteColor[16];
	D3DXCOLOR m_NoteColorOfScale[12];
	D3DXCOLOR m_ActiveNoteEmissive;
	D3DXCOLOR m_GridLineColor;
	D3DXCOLOR m_PlaybackSectionColor;

	int m_ActiveNoteDuration;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

	float m_ActiveNoteWhiteRate;
	float m_ActiveNoteBoxSizeRatio;

// >>> modify access level 20161224 yossiepon begin
private:
// <<< modify 20161224 yossiepon end

	int m_RippleDuration;

	int m_LiveMonitorDisplayDuration;
	float m_LiveNoteLengthPerSecond;

// >>> modify access level to protected 20161224 yossiepon begin
protected:
// <<< modify 20161224 yossiepon end

// >>> modify 20120728 yossiepon begin
	virtual void _Clear();
	virtual int _LoadConfFile(const TCHAR* pSceneName);
// <<< modify 20120728 yossiepon end

	int _LoadUserConf();

};


