package util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * Yahoo Web APIを利用した形態素解析を行うクラス
 *
 * @author kanazawa
 *
 */
public class MorphemeAnalyzer {
    private static final String appid = "dj0yJmk9SkhvNXRDTjZuTVR2JmQ9WVdrOVJEbFBSR1JNTTJVbWNHbzlNQS0tJnM9Y29uc3VtZXJzZWNyZXQmeD0wOA--";
    private Element root; // ルートノード

    public void doAnalyze(String sentence) throws IOException {
        // 検索WebサービスのURL
        // アプリケーションIDとクエリを指定して接続する
        URL url = new URL("http://jlp.yahooapis.jp/MAService/V1/parse?appid=" + appid +
                          "&results=ma,uniq&uniq_filter=9|10&sentence=" + sentence);
        URLConnection uc = url.openConnection();
        // 結果を読み出すためのストリーム
        InputStream is = uc.getInputStream();


        try {
            // 検索結果はXMLで返ってくるのでXMLパーサで解析
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(is);

            // ルートノード
            root = doc.getDocumentElement();

        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        } catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public ArrayList< Map<String, String> > getMaResult() {
        ArrayList< Map<String, String> > ma_result = new ArrayList< Map<String, String> >();
        // ma_resultノードを取得
        NodeList ma_result_node = root.getElementsByTagName("ma_result");
        // ma_resultノードは1つだけしかないのでそれを取得
        Element element = (Element)ma_result_node.item(0);
        // 各ノードを収集
        NodeList surfaceList = element.getElementsByTagName("surface");
        NodeList readingList = element.getElementsByTagName("reading");
        NodeList     posList = element.getElementsByTagName("pos");
        // ノードの各要素をそれぞれ取得
        for(int i = 0; i < surfaceList.getLength(); i++) {
            Map<String, String> map = new HashMap<String, String>();
            Element surfaceElement = (Element)surfaceList.item(i);
            Element readingElement = (Element)readingList.item(i);
            Element     posElement = (Element)    posList.item(i);

            String surface = surfaceElement.getFirstChild().getNodeValue();
            String reading = readingElement.getFirstChild().getNodeValue();
            String     pos =     posElement.getFirstChild().getNodeValue();
            map.put("surface", surface);
            map.put("reading", reading);
            map.put("pos"    ,     pos);
            ma_result.add(map);
        }
        return ma_result;
    }

    public ArrayList< Map<String, String> > getUniqResult() {
        ArrayList< Map<String, String> > uniq_result = new ArrayList< Map<String, String> >();
        // uniq_resultノードを取得
        NodeList uniq_result_node = root.getElementsByTagName("uniq_result");
        // uniq_resultノードは1つだけしかないのでそれを取得
        Element element = (Element)uniq_result_node.item(0);
        // 各ノードを収集
        NodeList   countList = element.getElementsByTagName("count");
        NodeList surfaceList = element.getElementsByTagName("surface");
//        NodeList readingList = element.getElementsByTagName("reading");
        NodeList     posList = element.getElementsByTagName("pos");
        // ノードの各要素をそれぞれ取得
        for(int i = 0; i < surfaceList.getLength(); i++) {
            Map<String, String> map = new HashMap<String, String>();
            Element   countElement = (Element)  countList.item(i);
            Element surfaceElement = (Element)surfaceList.item(i);
//            Element readingElement = (Element)readingList.item(i);
            Element     posElement = (Element)    posList.item(i);

            String   count =   countElement.getFirstChild().getNodeValue();
            String surface = surfaceElement.getFirstChild().getNodeValue();
//            String reading = readingElement.getFirstChild().getNodeValue();
            String     pos =     posElement.getFirstChild().getNodeValue();
            map.put("count"  ,   count);
            map.put("surface", surface);
//            map.put("reading", reading);
            map.put("pos"    ,     pos);
            uniq_result.add(map);
        }
        return uniq_result;
    }

}
