/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.Observer;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class Observers<T> {
    private final Collection<Observer<T>> observers = new CopyOnWriteArrayList<Observer<T>>();

    public static <T> Observers<T> create() {
        return new Observers<T>();
    }

    private Observers() {
    }

    public void add(Observer<T> o) {
        this.observers.add(o);
    }

    public void remove(Observer<T> o) {
        this.observers.remove(o);
    }

    public void notifyObserversAndClear(T subject) {
        for (Observer<T> o : this.observers) {
            o.update(subject);
        }
        this.observers.clear();
    }
}

