/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.util.Locale;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = type;
    }

    @Override
    public final DateTimeFieldType getType() {
        return this.iType;
    }

    @Override
    public final String getName() {
        return this.iType.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    @Override
    public abstract int get(long var1);

    @Override
    public String getAsText(long instant, Locale locale) {
        return this.getAsText(this.get(instant), locale);
    }

    @Override
    public final String getAsText(long instant) {
        return this.getAsText(instant, null);
    }

    @Override
    public String getAsText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.getAsText(fieldValue, locale);
    }

    @Override
    public final String getAsText(ReadablePartial partial, Locale locale) {
        return this.getAsText(partial, partial.get(this.getType()), locale);
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        return Integer.toString(fieldValue);
    }

    @Override
    public String getAsShortText(long instant, Locale locale) {
        return this.getAsShortText(this.get(instant), locale);
    }

    @Override
    public final String getAsShortText(long instant) {
        return this.getAsShortText(instant, null);
    }

    @Override
    public String getAsShortText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.getAsShortText(fieldValue, locale);
    }

    @Override
    public final String getAsShortText(ReadablePartial partial, Locale locale) {
        return this.getAsShortText(partial, partial.get(this.getType()), locale);
    }

    @Override
    public String getAsShortText(int fieldValue, Locale locale) {
        return this.getAsText(fieldValue, locale);
    }

    @Override
    public long add(long instant, int value) {
        return this.getDurationField().add(instant, value);
    }

    @Override
    public long add(long instant, long value) {
        return this.getDurationField().add(instant, value);
    }

    @Override
    public int[] add(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        long proposed;
        if (valueToAdd == 0) {
            return values;
        }
        DateTimeField nextField = null;
        while (valueToAdd > 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int max = this.getMaximumValue(instant, values);
            if (proposed <= (long)max) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField().getType() != nextField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= max + 1 - values[fieldIndex];
            values = nextField.add(instant, fieldIndex - 1, values, 1);
            values[fieldIndex] = this.getMinimumValue(instant, values);
        }
        while (valueToAdd < 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int min = this.getMinimumValue(instant, values);
            if (proposed >= (long)min) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField().getType() != nextField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= min - 1 - values[fieldIndex];
            values = nextField.add(instant, fieldIndex - 1, values, -1);
            values[fieldIndex] = this.getMaximumValue(instant, values);
        }
        return this.set(instant, fieldIndex, values, values[fieldIndex]);
    }

    @Override
    public int[] addWrapPartial(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        long proposed;
        if (valueToAdd == 0) {
            return values;
        }
        DateTimeField nextField = null;
        while (valueToAdd > 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int max = this.getMaximumValue(instant, values);
            if (proposed <= (long)max) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    valueToAdd -= max + 1 - values[fieldIndex];
                    values[fieldIndex] = this.getMinimumValue(instant, values);
                    continue;
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField().getType() != nextField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= max + 1 - values[fieldIndex];
            values = nextField.addWrapPartial(instant, fieldIndex - 1, values, 1);
            values[fieldIndex] = this.getMinimumValue(instant, values);
        }
        while (valueToAdd < 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int min = this.getMinimumValue(instant, values);
            if (proposed >= (long)min) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    valueToAdd -= min - 1 - values[fieldIndex];
                    values[fieldIndex] = this.getMaximumValue(instant, values);
                    continue;
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField().getType() != nextField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= min - 1 - values[fieldIndex];
            values = nextField.addWrapPartial(instant, fieldIndex - 1, values, -1);
            values[fieldIndex] = this.getMaximumValue(instant, values);
        }
        return this.set(instant, fieldIndex, values, values[fieldIndex]);
    }

    @Override
    public long addWrapField(long instant, int value) {
        int current = this.get(instant);
        int wrapped = FieldUtils.getWrappedValue(current, value, this.getMinimumValue(instant), this.getMaximumValue(instant));
        return this.set(instant, wrapped);
    }

    @Override
    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        int current = values[fieldIndex];
        int wrapped = FieldUtils.getWrappedValue(current, valueToAdd, this.getMinimumValue(instant), this.getMaximumValue(instant));
        return this.set(instant, fieldIndex, values, wrapped);
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifference(minuendInstant, subtrahendInstant);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    @Override
    public abstract long set(long var1, int var3);

    @Override
    public int[] set(ReadablePartial partial, int fieldIndex, int[] values, int newValue) {
        FieldUtils.verifyValueBounds(this, newValue, this.getMinimumValue(partial, values), this.getMaximumValue(partial, values));
        values[fieldIndex] = newValue;
        for (int i = fieldIndex + 1; i < partial.size(); ++i) {
            DateTimeField field = partial.getField(i);
            if (values[i] > field.getMaximumValue(partial, values)) {
                values[i] = field.getMaximumValue(partial, values);
            }
            if (values[i] >= field.getMinimumValue(partial, values)) continue;
            values[i] = field.getMinimumValue(partial, values);
        }
        return values;
    }

    @Override
    public long set(long instant, String text, Locale locale) {
        int value = this.convertText(text, locale);
        return this.set(instant, value);
    }

    @Override
    public final long set(long instant, String text) {
        return this.set(instant, text, null);
    }

    @Override
    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, String text, Locale locale) {
        int value = this.convertText(text, locale);
        return this.set(instant, fieldIndex, values, value);
    }

    protected int convertText(String text, Locale locale) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new IllegalFieldValueException(this.getType(), text);
        }
    }

    @Override
    public abstract DurationField getDurationField();

    @Override
    public abstract DurationField getRangeDurationField();

    @Override
    public boolean isLeap(long instant) {
        return false;
    }

    @Override
    public int getLeapAmount(long instant) {
        return 0;
    }

    @Override
    public DurationField getLeapDurationField() {
        return null;
    }

    @Override
    public abstract int getMinimumValue();

    @Override
    public int getMinimumValue(long instant) {
        return this.getMinimumValue();
    }

    @Override
    public int getMinimumValue(ReadablePartial instant) {
        return this.getMinimumValue();
    }

    @Override
    public int getMinimumValue(ReadablePartial instant, int[] values) {
        return this.getMinimumValue(instant);
    }

    @Override
    public abstract int getMaximumValue();

    @Override
    public int getMaximumValue(long instant) {
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial instant) {
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial instant, int[] values) {
        return this.getMaximumValue(instant);
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        int max = this.getMaximumValue();
        if (max >= 0) {
            if (max < 10) {
                return 1;
            }
            if (max < 100) {
                return 2;
            }
            if (max < 1000) {
                return 3;
            }
        }
        return Integer.toString(max).length();
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        return this.getMaximumTextLength(locale);
    }

    @Override
    public abstract long roundFloor(long var1);

    @Override
    public long roundCeiling(long instant) {
        long newInstant = this.roundFloor(instant);
        if (newInstant != instant) {
            instant = this.add(newInstant, 1);
        }
        return instant;
    }

    @Override
    public long roundHalfFloor(long instant) {
        long ceiling;
        long diffToCeiling;
        long floor = this.roundFloor(instant);
        long diffFromFloor = instant - floor;
        if (diffFromFloor <= (diffToCeiling = (ceiling = this.roundCeiling(instant)) - instant)) {
            return floor;
        }
        return ceiling;
    }

    @Override
    public long roundHalfCeiling(long instant) {
        long diffFromFloor;
        long floor = this.roundFloor(instant);
        long ceiling = this.roundCeiling(instant);
        long diffToCeiling = ceiling - instant;
        if (diffToCeiling <= (diffFromFloor = instant - floor)) {
            return ceiling;
        }
        return floor;
    }

    @Override
    public long roundHalfEven(long instant) {
        long ceiling;
        long diffToCeiling;
        long floor = this.roundFloor(instant);
        long diffFromFloor = instant - floor;
        if (diffFromFloor < (diffToCeiling = (ceiling = this.roundCeiling(instant)) - instant)) {
            return floor;
        }
        if (diffToCeiling < diffFromFloor) {
            return ceiling;
        }
        if ((this.get(ceiling) & 1) == 0) {
            return ceiling;
        }
        return floor;
    }

    @Override
    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    @Override
    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

