/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.QueryOptions;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.QueryChecker;

public class Query {
    private final String query;
    private final QueryOptions options;

    protected Query(Builder builder) {
        this.query = builder.queryString;
        this.options = builder.options;
        this.checkValid();
    }

    public String getQueryString() {
        return this.query;
    }

    public QueryOptions getOptions() {
        return this.options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Query query) {
        return new Builder(query);
    }

    private Query checkValid() {
        Preconditions.checkNotNull(this.query, "query cannot be null");
        return this;
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer() {
        SearchServicePb.SearchParams.Builder builder = SearchServicePb.SearchParams.newBuilder().setQuery(this.query);
        if (this.options == null) {
            QueryOptions.newBuilder().build().copyToProtocolBuffer(builder, this.query);
        } else {
            this.options.copyToProtocolBuffer(builder, this.query);
        }
        return builder;
    }

    public String toString() {
        return String.format("Query(queryString=%s%s)", this.query, Util.fieldToString("options", this.options));
    }

    public static class Builder {
        private String queryString;
        private QueryOptions options;

        protected Builder() {
        }

        private Builder(Query query) {
            this.queryString = query.getQueryString();
            this.options = query.getOptions();
        }

        public Builder setOptions(QueryOptions options) {
            this.options = options;
            return this;
        }

        public Builder setOptions(QueryOptions.Builder optionsBuilder) {
            return this.setOptions(optionsBuilder.build());
        }

        protected Builder setQueryString(String query) {
            this.queryString = QueryChecker.checkQuery(query);
            return this;
        }

        public Query build(String queryString) {
            this.setQueryString(queryString);
            return new Query(this);
        }

        public Query build() {
            return new Query(this);
        }
    }
}

