/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.field.BaseDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.BaseDurationField;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;

public abstract class ImpreciseDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 7190739608550251860L;
    final long iUnitMillis;
    private final DurationField iDurationField;

    public ImpreciseDateTimeField(DateTimeFieldType type, long unitMillis) {
        super(type);
        this.iUnitMillis = unitMillis;
        this.iDurationField = new LinkedDurationField(type.getDurationType());
    }

    @Override
    public abstract int get(long var1);

    @Override
    public abstract long set(long var1, int var3);

    @Override
    public abstract long add(long var1, int var3);

    @Override
    public abstract long add(long var1, long var3);

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return FieldUtils.safeToInt(this.getDifferenceAsLong(minuendInstant, subtrahendInstant));
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifferenceAsLong(subtrahendInstant, minuendInstant);
        }
        long difference = (minuendInstant - subtrahendInstant) / this.iUnitMillis;
        if (this.add(subtrahendInstant, difference) < minuendInstant) {
            while (this.add(subtrahendInstant, ++difference) <= minuendInstant) {
            }
            --difference;
        } else if (this.add(subtrahendInstant, difference) > minuendInstant) {
            while (this.add(subtrahendInstant, --difference) > minuendInstant) {
            }
        }
        return difference;
    }

    @Override
    public final DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public abstract DurationField getRangeDurationField();

    @Override
    public abstract long roundFloor(long var1);

    protected final long getDurationUnitMillis() {
        return this.iUnitMillis;
    }

    private final class LinkedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -203813474600094134L;

        LinkedDurationField(DurationFieldType type) {
            super(type);
        }

        @Override
        public boolean isPrecise() {
            return false;
        }

        @Override
        public long getUnitMillis() {
            return ImpreciseDateTimeField.this.iUnitMillis;
        }

        @Override
        public int getValue(long duration, long instant) {
            return ImpreciseDateTimeField.this.getDifference(instant + duration, instant);
        }

        @Override
        public long getValueAsLong(long duration, long instant) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(instant + duration, instant);
        }

        @Override
        public long getMillis(int value, long instant) {
            return ImpreciseDateTimeField.this.add(instant, value) - instant;
        }

        @Override
        public long getMillis(long value, long instant) {
            return ImpreciseDateTimeField.this.add(instant, value) - instant;
        }

        @Override
        public long add(long instant, int value) {
            return ImpreciseDateTimeField.this.add(instant, value);
        }

        @Override
        public long add(long instant, long value) {
            return ImpreciseDateTimeField.this.add(instant, value);
        }

        @Override
        public int getDifference(long minuendInstant, long subtrahendInstant) {
            return ImpreciseDateTimeField.this.getDifference(minuendInstant, subtrahendInstant);
        }

        @Override
        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            return ImpreciseDateTimeField.this.getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }
    }
}

