/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.escape;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.escape.ArrayBasedCharEscaper;
import com.google.appengine.repackaged.com.google.common.escape.CharEscaper;
import com.google.appengine.repackaged.com.google.common.escape.Escaper;
import com.google.appengine.repackaged.com.google.common.escape.UnicodeEscaper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@Beta
@GwtCompatible
public final class Escapers {
    private static final CharEscaper NULL_ESCAPER = new CharEscaper(){

        @Override
        public String escape(String string) {
            return Preconditions.checkNotNull(string);
        }

        @Override
        protected char[] escape(char c) {
            return null;
        }
    };

    private Escapers() {
    }

    public static CharEscaper nullEscaper() {
        return NULL_ESCAPER;
    }

    public static Builder builder() {
        return new Builder();
    }

    @GoogleInternal
    public static Escaper combine(Escaper ... escapers) {
        int numEscapers = escapers.length;
        if (numEscapers == 0) {
            return Escapers.nullEscaper();
        }
        if (numEscapers == 1) {
            return Preconditions.checkNotNull(escapers[0]);
        }
        boolean onlyCharEscapers = true;
        for (Escaper escaper : escapers) {
            if (escaper instanceof CharEscaper) continue;
            onlyCharEscapers = false;
            break;
        }
        if (onlyCharEscapers) {
            final CharEscaper[] charEscapers = new CharEscaper[numEscapers];
            System.arraycopy(escapers, 0, charEscapers, 0, numEscapers);
            return new CharEscaper(){

                @Override
                protected char[] escape(char c) {
                    for (CharEscaper e : charEscapers) {
                        char[] chars = e.escape(c);
                        if (chars == null) continue;
                        return chars;
                    }
                    return null;
                }
            };
        }
        final UnicodeEscaper[] unicodeEscapers = new UnicodeEscaper[numEscapers];
        for (int n = 0; n < numEscapers; ++n) {
            unicodeEscapers[n] = Escapers.asUnicodeEscaper(escapers[n]);
        }
        return new UnicodeEscaper(){

            @Override
            protected char[] escape(int cp) {
                for (UnicodeEscaper e : unicodeEscapers) {
                    char[] chars = e.escape(cp);
                    if (chars == null) continue;
                    return chars;
                }
                return null;
            }
        };
    }

    public static UnicodeEscaper asUnicodeEscaper(Escaper escaper) {
        Preconditions.checkNotNull(escaper);
        if (escaper instanceof UnicodeEscaper) {
            return (UnicodeEscaper)escaper;
        }
        if (escaper instanceof CharEscaper) {
            return Escapers.wrap((CharEscaper)escaper);
        }
        throw new IllegalArgumentException("Cannot create a UnicodeEscaper from: " + escaper.getClass().getName());
    }

    public static String computeReplacement(CharEscaper escaper, char c) {
        return Escapers.stringOrNull(escaper.escape(c));
    }

    public static String computeReplacement(UnicodeEscaper escaper, int cp) {
        return Escapers.stringOrNull(escaper.escape(cp));
    }

    private static String stringOrNull(char[] in) {
        return in == null ? null : new String(in);
    }

    private static UnicodeEscaper wrap(final CharEscaper escaper) {
        return new UnicodeEscaper(){

            @Override
            protected char[] escape(int cp) {
                int n;
                if (cp < 65536) {
                    return escaper.escape((char)cp);
                }
                char[] surrogateChars = new char[2];
                Character.toChars(cp, surrogateChars, 0);
                char[] hiChars = escaper.escape(surrogateChars[0]);
                char[] loChars = escaper.escape(surrogateChars[1]);
                if (hiChars == null && loChars == null) {
                    return null;
                }
                int hiCount = hiChars != null ? hiChars.length : 1;
                int loCount = loChars != null ? loChars.length : 1;
                char[] output = new char[hiCount + loCount];
                if (hiChars != null) {
                    for (n = 0; n < hiChars.length; ++n) {
                        output[n] = hiChars[n];
                    }
                } else {
                    output[0] = surrogateChars[0];
                }
                if (loChars != null) {
                    for (n = 0; n < loChars.length; ++n) {
                        output[hiCount + n] = loChars[n];
                    }
                } else {
                    output[hiCount] = surrogateChars[1];
                }
                return output;
            }
        };
    }

    @Beta
    public static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMin = '\u0000';
        private char safeMax = (char)65535;
        private String unsafeReplacement = null;

        private Builder() {
        }

        public Builder setSafeRange(char safeMin, char safeMax) {
            this.safeMin = safeMin;
            this.safeMax = safeMax;
            return this;
        }

        public Builder setUnsafeReplacement(@Nullable String unsafeReplacement) {
            this.unsafeReplacement = unsafeReplacement;
            return this;
        }

        public Builder addEscape(char c, String replacement) {
            Preconditions.checkNotNull(replacement);
            this.replacementMap.put(Character.valueOf(c), replacement);
            return this;
        }

        public Escaper build() {
            return new ArrayBasedCharEscaper(this.replacementMap, this.safeMin, this.safeMax){
                private final char[] replacementChars;
                {
                    this.replacementChars = Builder.this.unsafeReplacement != null ? Builder.this.unsafeReplacement.toCharArray() : null;
                }

                @Override
                protected char[] escapeUnsafe(char c) {
                    return this.replacementChars;
                }
            };
        }
    }
}

