/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.Strongly;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.base.Hash;

@GoogleInternal
public final class FP {
    private FP() {
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-09-01")
    public static long fingerprint(byte[] value, int offset, int length) {
        int hi = FP.hash32(value, offset, length, 0);
        int lo = FP.hash32(value, offset, length, 102072);
        return Hash.combineFingerprints(hi, lo);
    }

    @Deprecated
    @Strongly(contact="java-core-libraries-team", date="2012-09-01")
    public static long fingerprint(String value) {
        byte[] tmp = value.getBytes(Charsets.UTF_8);
        return FP.fingerprint(tmp, 0, tmp.length);
    }

    private static int word32At(byte[] bytes, int offset) {
        return bytes[offset + 0] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    @VisibleForTesting
    static int hash32(byte[] value, int offset, int length, int seed) {
        int a = -1640531527;
        int b = -1640531527;
        int c = seed;
        int keylen = length;
        while (keylen >= 12) {
            a += FP.word32At(value, offset);
            a -= (b += FP.word32At(value, offset + 4));
            a -= (c += FP.word32At(value, offset + 8));
            b -= c;
            b -= (a ^= c >>> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >>> 13);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >>> 15;
            keylen -= 12;
            offset += 12;
        }
        c += length;
        switch (keylen) {
            case 11: {
                c += value[offset + 10] << 24;
            }
            case 10: {
                c += (value[offset + 9] & 0xFF) << 16;
            }
            case 9: {
                c += (value[offset + 8] & 0xFF) << 8;
            }
            case 8: {
                b += FP.word32At(value, offset + 4);
                a += FP.word32At(value, offset);
                break;
            }
            case 7: {
                b += (value[offset + 6] & 0xFF) << 16;
            }
            case 6: {
                b += (value[offset + 5] & 0xFF) << 8;
            }
            case 5: {
                b += value[offset + 4] & 0xFF;
            }
            case 4: {
                a += FP.word32At(value, offset);
                break;
            }
            case 3: {
                a += (value[offset + 2] & 0xFF) << 16;
            }
            case 2: {
                a += (value[offset + 1] & 0xFF) << 8;
            }
            case 1: {
                a += value[offset + 0] & 0xFF;
            }
        }
        return Hash.mix32(a, b, c);
    }
}

