/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Asset;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public final class Document {
    private final List<Asset> assets = Lists.newArrayList();

    public Document(Asset firstAsset) {
        this.assets.add(Preconditions.checkNotNull(firstAsset));
    }

    public Document(List<Asset> assets) {
        Preconditions.checkNotNull(assets);
        Preconditions.checkArgument(assets.size() > 0, "The assets list should not be empty");
        this.assets.addAll(assets);
    }

    public List<Asset> getAssets() {
        return Collections.unmodifiableList(this.assets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equal(this.assets, ((Document)o).getAssets());
    }

    public int hashCode() {
        return Objects.hashCode(this.assets);
    }
}

