//! @file objectmanager.h
//! @brief ObjectManagerNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef OBJECTMANAGER_H
#define OBJECTMANAGER_H

#define MAX_HUMAN 96			//!< ől
#define MAX_WEAPON 200			//!< ̍ő吔
#define MAX_SMALLOBJECT 40		//!< ̍ő吔

#define MAX_BULLET 128			//!< ee̍ő吔
#define MAX_GRENADE 32			//!< ֒e̍ő吔
#define MAX_EFFECT 256			//!< GtFNg̍ő吔

#define WEAPONSHOT_HEIGHT (VIEW_HEIGHT)	//!< e𔭎˂鍂

#define TOTAL_WEAPON_AUTOBULLET 3	//!< ɎIɕĂ񂳂eiẻ{j

#define SMALLOBJECT_SCALE 0.13f	//!< 蔻̔{

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif
#include "main.h"

//! GtFNg`vZp\
struct effectdata{
	int id;		//!< f[^ԍ
	float dist;	//!< 
};

//! @brief IuWFNgǗNX
//! @details eIuWFNg̏EvZE`ȂǂsǗ܂B
class ObjectManager
{
	class human *HumanIndex;					//!< lIuWFNg
	class weapon *WeaponIndex;					//!< IuWFNg
	class smallobject *SmallObjectIndex;		//!< IuWFNg
	class bullet *BulletIndex;					//!< eIuWFNg
	class grenade *GrenadeIndex;				//!< ֒eIuWFNg
	class effect *EffectIndex;				//!< ֒eIuWFNg

	unsigned int framecnt;		//!< t[̃JEg

	int *Human_ontarget;	//!< 
	int *Human_kill;		//!< |G̐
	int *Human_headshot;	//!< G̓ɖ

	int Player_HumanID;		//!< vC[삷lIuWFNgID

	int AddHumanIndex_TextureID;		//!< Oǂݍ񂾃eNX`ID

	ParameterInfo *GameParamInfo;		//!< Q[̐ݒl
	D3DGraphics *d3dg;					//!< `NX
	ResourceManager *Resource;			//!< \[XǗ
	BlockDataInterface *BlockData;		//!< ubNf[^ǗNX
	PointDataInterface *PointData;		//!< |Cgf[^ǗNX
	Collision *CollD;					//!< 蔻ǗNX
	SoundManager *GameSound;				//!< Q[ʉǗNX
	MIFInterface *MIFdata;				//!< MIFRg[NX

	int AddHumanIndex(pointdata data, pointdata infodata);
	int AddWeaponIndex(pointdata data);
	int AddSmallObjectIndex(pointdata data);
	void SetHumanBlood(float x, float y, float z);
	bool CollideHuman(human *in_humanA, human *in_humanB);
	bool CollideBullet(bullet *in_bullet);
	void HitBulletMap(float x, float y, float z);
	void HitBulletHuman(int HitHuman_id, int Hit_id, float x, float y, float z, float brx, int attacks, int humanid);
	void HitBulletSmallObject(int HitSmallObject_id, float x, float y, float z, int attacks);
	void PickupWeapon(human *in_human, weapon *in_weapon);
	void CleanupPointDataToObject();
	int SortEffect(float camera_x, float camera_y, float camera_z, effectdata data[]);

public:
	ObjectManager();
	~ObjectManager();
	void SetClass(ParameterInfo *in_GameParamInfo, D3DGraphics *in_d3dg, ResourceManager *in_Resource, BlockDataInterface *in_BlockData, PointDataInterface *in_PointData, Collision *in_CollD, SoundManager *in_GameSound, MIFInterface *in_MIFdata);
	int AddHumanIndex(float px, float py, float pz, float rx, int CharacterID, int TeamID, int WeaponID[]);
	int AddVisualWeaponIndex(int WeaponID, bool loadbullet);
	void LoadPointData();
	human* GetHumanList();
	weapon* GetWeaponList();
	smallobject* GetSmallObjectList();
	bullet* GetBulletList();
	int GetPlayerID();
	void SetPlayerID(int id);
	human* GeHumanObject(int id);
	human* GetPlayerHumanObject();
	weapon* GeWeaponObject(int id);
	bullet* GeBulletObject(int id);
	bullet* GetNewBulletObject();
	grenade* GetNewGrenadeObject();
	human* SearchHuman(signed char p4);
	smallobject* SearchSmallobject(signed char p4);
	int ShotWeapon(human *MyHuman);
	void ReloadWeapon(human *in_human);
	bool CheckZombieAttack(human* MyHuman, human* EnemyHuman);
	void HitZombieAttack(human* EnemyHuman);
	int CheckGameOverorComplete();
	int Process(int cmdF5id, float camera_x, float camera_y, float camera_z, float camera_rx, float camera_ry);
	bool GetHumanShotInfo(int id, int *ontarget, int *kill, int *headshot);
	void Render(float camera_x, float camera_y, float camera_z, int HidePlayer);
	void Cleanup();
};

#endif