//! @file ai.cpp
//! @brief AIcontrolNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "ai.h"

//! RXgN^
AIcontrol::AIcontrol(class ObjectManager *in_ObjMgr, class human *in_ctrlhuman, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlhuman = in_ctrlhuman;
	blocks = in_blocks;
	Points = in_Points;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;

	battlemode = AI_NORMAL;
	movemode = AI_WAIT;
	target_pointid = -1;
	target_posx = 0.0f;
	target_posz = 0.0f;
	target_rx = 0.0f;
	total_move = 0.0f;
	waitcnt = 0;
	movejumpcnt = 1*((int)GAMEFPS);
	gotocnt = 0;
	moveturn_mode = 0;
	longattack = false;
}

//! fBXgN^
AIcontrol::~AIcontrol()
{}

//! ΏۃNXݒ
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void AIcontrol::SetClass(class ObjectManager *in_ObjMgr, class human *in_ctrlhuman, class BlockDataInterface *in_blocks, class PointDataInterface *in_Points, class ParameterInfo *in_Param, class Collision *in_CollD, class SoundManager *in_GameSound)
{
	ObjMgr = in_ObjMgr;
	ctrlhuman = in_ctrlhuman;
	blocks = in_blocks;
	Points = in_Points;
	Param = in_Param;
	CollD = in_CollD;
	GameSound = in_GameSound;
}

//! _ȐlԂ
//! @param num ͈
//! @return 0`num-1
int AIcontrol::random(int num)
{
	return GetRand(num);
}

//! l
//! @param in_p4 l̑4p[^iFԍj
//! @param out_x XW󂯎|C^
//! @param out_z ZW󂯎|C^
//! @return F1@sF0
int AIcontrol::SearchHumanPos(signed char in_p4, float *out_x, float *out_z)
{
	float x, z;
	human* thuman;

	//lăNX擾
	thuman = ObjMgr->SearchHuman(in_p4);
	if( thuman == NULL ){ return 0; }

	//XEZW擾
	thuman->GetPosData(&x, NULL, &z, NULL);
	*out_x = x;
	*out_z = z;
	return 1;
}

//! ڕWn_ɈړĂ邩mF
//! @return BFtrue@񓞒BFfalse
bool AIcontrol::CheckTargetPos()
{
	//Zo
	float x = posx - target_posx;
	float z = posz - target_posz;
	float r = x * x + z * z;

	if( movemode == AI_TRACKING ){	//ǔȂ
		if( r < AI_ARRIVALDIST_TRACKING * AI_ARRIVALDIST_TRACKING ){
			return true;
		}
	}
	else{							//ȊOȂ
		if( r < (AI_ARRIVALDIST_PATH * AI_ARRIVALDIST_PATH) ){
			return true;
		}
	}

	return false;
}

//! ڕWn_
//! @param next 
//! @return Ftrue@sFfalse
bool AIcontrol::SearchTarget(bool next)
{
	//|Cg̏擾
	pointdata pdata;
	if( Points->Getdata(&pdata, target_pointid) != 0 ){
		movemode = AI_NULL;
		return false;
	}

	int nextpointp4;

	//̃|CgȂ
	if( next == true ){
		nextpointp4 = pdata.p3;

		//_pX
		if( pdata.p1 == 8 ){
			if( random(2) == 0 ){
				nextpointp4 = pdata.p2;
			}
			else{
				nextpointp4 = pdata.p3;
			}
			movemode = AI_RANDOM;
		}

		//|Cg
		if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
			return false;
		}
	}

	//_pXȂ玟
	if( pdata.p1 == 8 ){
		target_pointid = pdata.id;
		movemode = AI_RANDOM;
		return false;
	}

	//lȂW擾
	if( (pdata.p1 == 1)||(pdata.p1 == 6) ){
		SearchHumanPos(pdata.p4, &target_posx, &target_posz);
		return true;
	}

	//ړpXȂ`
	if( pdata.p1 == 3 ){
		//Kp
		target_pointid = pdata.id;
		target_posx = pdata.x;
		target_posz = pdata.z;
		target_rx = pdata.r;

		//ړXe[gݒ
		switch(pdata.p2){
			case 0: movemode = AI_WALK; break;
			case 1: movemode = AI_RUN; break;
			case 2: movemode = AI_WAIT; break;
			case 3:
				movemode = AI_TRACKING;
				if( next == true ){
					nextpointp4 = pdata.p3;

					//|Cgilj̏擾
					if( Points->SearchPointdata(&pdata, 0x08, 0, 0, 0, nextpointp4, 0) == 0 ){
						return false;
					}

					//ۑ
					target_pointid = pdata.id;
					target_posx = pdata.x;
					target_posz = pdata.z;
				}
				break;
			case 4: movemode = AI_WAIT; break;
			case 5: movemode = AI_STOP; break;
			case 6: movemode = AI_GRENADE; break;
			case 7: movemode = AI_RUN2; break;
			default: break;
		}
		return true;
	}
	
	movemode = AI_NULL;
	return false;
}

//! ڕWn_Ɉړ
void AIcontrol::MoveTarget()
{
	float x = posx - target_posx;
	float z = posz - target_posz;
	float r = x * x + z * z;
	float atan;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//ڕWn_ւ̊px߂
	atan = atan2(x, z) - rx + (float)M_PI;
	for(; atan > (float)M_PI; atan -= (float)M_PI*2){}
	for(; atan < (float)M_PI*-1; atan += (float)M_PI*2){}

	//傫ȍΏÂ񂷂邾
	if( atan > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( atan < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	//X鍷ȂCɌ
	if( (atan <= AI_TURNRAD) && (atan >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		rx += atan;
	}

	//Oi
	if( zombie == true ){
		if( abs(atan) < (float)M_PI/18*2 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else if( battlemode == AI_CAUTION ){
		if( abs(atan) < (float)M_PI/18*5 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
		}
	}
	else if( movemode == AI_WALK ){
		if( abs(atan) < (float)M_PI/180*6 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else if( (movemode == AI_RUN)||(movemode == AI_RUN2) ){
		if( abs(atan) < (float)M_PI/18*5 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
		}
	}
	else if( (movemode == AI_WAIT)||(movemode == AI_STOP) ){
		if( abs(atan) < (float)M_PI/180*6 ){
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}
	}
	else{	//movemode == AI_TRACKING
		if( abs(atan) < (float)M_PI/18*2 ){
			if( r < (AI_ARRIVALDIST_WALKTRACKING * AI_ARRIVALDIST_WALKTRACKING) ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			else{
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			}
		}
	}

	//Wv
	if( random(128) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( random(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( random(2) == 0 ){ SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT); }
				else{ SetFlag(moveturn_mode, AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! ڕWn_ɈړiDIȑpj
void AIcontrol::MoveTarget2()
{
	float x = target_posx - posx;
	float z = target_posz - posz;
	float atan, rx2, trx;

	//ľE_߂@i0.0`2΁j
	rx2 = rx*-1 + (float)M_PI/2;
	for(; rx2 > (float)M_PI*2; rx2 -= (float)M_PI*2){}
	for(; rx2 < 0.0f; rx2 += (float)M_PI*2){}

	//|Cg܂ł̊px߂@i0.0`2΁j
	trx = atan2(z, x);
	if( trx < 0.0f ){ trx += (float)M_PI*2; }

	//_Ƀ|Cg܂ł̊pxZoi-΁`΁j
	atan = trx - rx2;
	for(; atan > (float)M_PI; atan -= (float)M_PI*2){}
	for(; atan < (float)M_PI*-1; atan += (float)M_PI*2){}

	//Oړ̏
	if( abs(atan) < (float)M_PI/180*56 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( abs(atan) > (float)M_PI/180*123.5f ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}

	//Eړ̏
	if( ((float)M_PI/180*-146 < atan)&&(atan < (float)M_PI/180*-33) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( ((float)M_PI/180*33 < atan)&&(atan < (float)M_PI/180*146) ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	//Wv
	if( random(128) == 0 ){
		MoveJump();
	}

	//|ĂAEւ̉]_ɍs
	if( random(28) == 0 ){
		if( ctrlhuman->GetMovemode(true) != 0 ){
			if( ctrlhuman->GetTotalMove() - total_move < 0.1f ){
				if( random(2) == 0 ){ SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT); }
				else{ SetFlag(moveturn_mode, AI_CTRL_TURNLEFT); }
			}
		}
	}
	total_move = ctrlhuman->GetTotalMove();
}

//! O㍶E_ɈړiUpj
void AIcontrol::MoveRandom()
{
	int forwardstart, backstart, sidestart;

	if( longattack == false ){
		forwardstart = 80;
		backstart = 90;
		sidestart = 70;
	}
	else{
		forwardstart = 120;
		backstart = 150;
		sidestart = 130;
	}

	//_Ɉړn߂
	if( random(forwardstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( random(backstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}
	if( random(sidestart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVELEFT);
	}
	if( random(sidestart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
	}

	// 1/3̊mAړtOݒ肳Ă
	if( (random(3) == 0)||(GetFlag(moveturn_mode, (AI_CTRL_MOVEFORWARD | AI_CTRL_MOVEBACKWARD | AI_CTRL_MOVELEFT | AI_CTRL_MOVERIGHT))) ){
		float vx, vz;
		float Dist;

		if( random(2) == 0 ){
			//ÕxNgvZ
			vx = cos(rx*-1 + (float)M_PI/2);
			vz = sin(rx*-1 + (float)M_PI/2);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 5.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//OitO폜AރtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}

			//̃xNgvZ
			vx = cos(rx*-1 + (float)M_PI/2 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI/2 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 5.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ރtO폜AOitOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			}
		}
		else{
			//
			vx = cos(rx*-1);
			vz = sin(rx*-1);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 5.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//EړtO폜AړtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
				SetFlag(moveturn_mode, AI_CTRL_MOVELEFT);
			}

			vx = cos(rx*-1 + (float)M_PI);
			vz = sin(rx*-1 + (float)M_PI);
			if(
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy + HUMAN_MAPCOLLISION_HEIGTH, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == true)||		//̍ɃubNiԂj
				(CollD->CheckALLBlockIntersectDummyRay(posx, posy - 5.0f, posz, vx, 0, vz, NULL, NULL, &Dist, HUMAN_MAPCOLLISION_R) == false)							//ɃubNȂij
			){
				//ړtO폜AEړtOݒ
				DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
				SetFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
			}
		}
	}

	//UΏۂȂ
	if( enemyhuman != NULL ){
		float tx, ty, tz;

		enemyhuman->GetPosData(&tx, &ty, &tz, NULL);

		float x = posx - tx;
		float y = posy - ty;
		float z = posz - tz;
		float r = x * x + y * y + z * z;

		//Gɋ߂ÂȂނ
		if( r < 20.0f * 20.0f ){
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			if( random(70) == 0 ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}
		}
	}
}

//! ̏܂킷
void AIcontrol::TurnSeen()
{
	int turnstart, turnstop;

	//]̊JnEImݒ
	if( battlemode == AI_ACTION ){
		return;
	}
	else if( battlemode == AI_CAUTION ){
		turnstart = 20;
		turnstop = 20;
	}
	else{
		if( movemode == AI_TRACKING ){ turnstart = 65; }
		else{ turnstart = 85; }
		turnstop = 18;
	}

	//_ɉ]n߂
	if( random(turnstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( random(turnstart) == 0 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	if( (battlemode == AI_NORMAL)&&(movemode == AI_WAIT) ){
		//_Ƀ|Cg̕Ƃ
		//u|Cg̕dv̍Č 
		if( random(80) == 0 ){
			float tr;
			tr = target_rx - rx;
			for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
			for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

			if( tr > 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
			}
			if( tr < 0.0f ){
				SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
			}
		}
	}

	//]_Ɏ~߂
	if( random(turnstop) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( random(turnstop) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
}

//! ̕
bool AIcontrol::StopSeen()
{
	float tr;
	bool returnflag;

	tr = target_rx - rx;
	for(; tr > (float)M_PI; tr -= (float)M_PI*2){}
	for(; tr < (float)M_PI*-1; tr += (float)M_PI*2){}

	//傫ȍΏÂ񂷂邾
	if( tr > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		returnflag = false;
	}
	if( tr < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		returnflag = false;
	}

	//X鍷ȂCɌB
	if( (tr <= AI_TURNRAD) && (tr >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		rx += tr;
		returnflag = true;
	}

	return returnflag;
}

//! isɏQ΃Wv
bool AIcontrol::MoveJump()
{
	//~܂ĂΏȂ
	if( ctrlhuman->GetMovemode(true) == 0 ){ return false; }

	float dist_dummy;

	float new_posx, new_posy, new_posz;

	//t߂̂蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	new_posy = posy + HUMAN_MAPCOLLISION_HEIGTH;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * (AI_CHECKJUMP_DIST + HUMAN_MAPCOLLISION_R);
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ctrlhuman->Jump();
		return true;
	}

	//̑Ŝ̂蔻
	new_posx = posx + cos(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	new_posy = posy + AI_CHECKJUMP_HEIGHT;
	new_posz = posz + sin(rx*-1 + (float)M_PI/2) * AI_CHECKJUMP_DIST;
	if( CollD->CheckALLBlockInside(new_posx, new_posy, new_posz) == true ){
		ctrlhuman->Jump();
		return true;
	}
	else if( CollD->CheckALLBlockIntersectRay(new_posx, new_posy, new_posz, 0.0f, 1.0f, 0.0f, NULL, NULL, &dist_dummy, HUMAN_HEIGTH - AI_CHECKJUMP_HEIGHT) == true ){
		ctrlhuman->Jump();
		return true;
	}

	return false;
}

//! U
//! @todo ]ȓ߂܂鏈
void AIcontrol::Action()
{
	human* EnemyHuman = NULL;
	int paramid;
	HumanParameter Paraminfo;
	bool zombie;
	float posy2;
	float tx, ty, tz;

	EnemyHuman = enemyhuman;

	//W擾
	EnemyHuman->GetPosData(&tx, &ty, &tz, NULL);
	posy2 = posy + VIEW_HEIGHT;
	ty += VIEW_HEIGHT;

	//]rǂ
	ctrlhuman->GetParamData(&paramid, NULL, NULL, NULL);
	Param->GetHuman(paramid, &Paraminfo);
	if( Paraminfo.type == 2 ){
		zombie = true;
	}
	else{
		zombie = false;
	}

	//Ă镐̎ނ擾
	int weaponid = ctrlhuman->GetMainWeaponTypeNO();

	float x = posx - tx;
	float y = posy2 - ty;
	float z = posz - tz;
	float r = x * x + z * z;
	float atan;

	//ڕWn_ւ̊px߂
	atan = atan2(x, z) - rx + (float)M_PI;
	for(; atan > (float)M_PI; atan -= (float)M_PI*2){}
	for(; atan < (float)M_PI*-1; atan += (float)M_PI*2){}

	//傫ȍΏÂ񂷂邾
	if( atan > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( atan < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}

	//X鍷ȂCɌ
	if( (atan <= AI_TURNRAD) && (atan >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		rx += atan;
		rx += (float)M_PI/180 * (random(5) - 2);
	}

	//r̊px
	if( zombie == true ){
		//ry = 0.0f;

		//傫ȍΏÂ񂷂邾
		if( ry < AI_TURNRAD*-1 ){
			SetFlag(moveturn_mode, AI_CTRL_TURNUP);
		}
		if( ry > AI_TURNRAD ){
			SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		}

		//X鍷ȂCɌ
		if( (ry <= AI_TURNRAD) && (ry >= AI_TURNRAD*-1) ){
			DelFlag(moveturn_mode, AI_CTRL_TURNUP);
			DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
			ry = 0.0f;
		}
	}
	else{
		float y2 = y;
		float sqrtr = sqrt(r);
		float addry;

		//Ă΁`
		if( weaponid != ID_WEAPON_NONE ){
			//G̈ړ
			/*
			if( weaponid == ID_WEAPON_GRENADE ){	//֒eȂ琂pxij
				float scale;
				if( sqrtr < 200.0f ){ scale = 0.12f; }
				else{ scale = 0.4f; }
				y2 += (sqrtr - 200.0f) * scale;
			}
			else{							//֒eȊOȂ琅px
				float mx, mz;
				EnemyHuman->GetMovePos(&mx, NULL, &mz);
				if( sqrtr < 200.0f ){ rx += atan2(mz * 1.5f, mx * 1.5f); }
				else{ rx += atan2(sqrtr * mz * 0.12f, sqrtr * mx * 0.12f); }
			}
			*/
		}

		//ԂȂ΁`
		if( weaponid == ID_WEAPON_NONE ){
			if( EnemyHuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//GԂȂ΁`
				addry = ARMRAD_NOWEAPON - ry;
			}
			else{														//GĂ΁`
				addry = (float)M_PI/18*8 - ry;
			}
		}
		else{
			addry = atan2(y2, sqrt(r)) * -1 - ry;
		}

		//傫ȍΏÂ񂷂邾
		if( addry > AI_TURNRAD ){
			SetFlag(moveturn_mode, AI_CTRL_TURNUP);
		}
		if( addry < AI_TURNRAD*-1 ){
			SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		}

		//X鍷ȂCɌ
		if( (addry <= AI_TURNRAD) && (addry >= AI_TURNRAD*-1) ){
			DelFlag(moveturn_mode, AI_CTRL_TURNUP);
			DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
			ry += addry;
			ry += (float)M_PI/180 * (random(5) - 2);
		}
	}

	//]rȊOŎԂȂ
	if( zombie == false ){
		if( weaponid == ID_WEAPON_NONE ){
			//̊mŌނ
			if( random(80) == 0 ){
				SetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			}
		}
	}

	
	if( zombie == true ){	//]r̍U

		//Ă΁Axɐ؂ւ
		if( GetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD) ){
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
		}

		//GɌđOi
		if( (atan <= (float)M_PI/180*25) && (atan >= (float)M_PI/180*25*-1) ){
			if( (atan <= (float)M_PI/180*15) && (atan >= (float)M_PI/180*15*-1) && (r < 24.0f*24.0f) && (actioncnt%50 > 20) ){
				//A
				SetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
				DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			else{
				SetFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
		}

		/*
		//Wv
		if( random(128) == 0 ){
			MoveJump();
		}
		*/

		if( (r < 9.0f*9.0f)&&( abs(y) < 10.0f) ){
			//߂܂@iGtj
			EnemyHuman->AddPosOrder(atan2(z, x), 1.2f);

			//G̎__ɓ
			float erx, ery;
			EnemyHuman->GetRxRy(&erx, &ery);
			switch(random(3)){
				case 0: erx -= (float)M_PI/180*2; break;
				case 1: erx += (float)M_PI/180*2; break;
				default: break;
			}
			switch(random(3)){
				case 0: ery -= (float)M_PI/180*2; break;
				case 1: ery += (float)M_PI/180*2; break;
				default: break;
			}
			EnemyHuman->SetRxRy(erx, ery);
		}

		if( actioncnt%50 == 0){
			if( ObjMgr->CheckZombieAttack(ctrlhuman, EnemyHuman) == true ){
				ObjMgr->HitZombieAttack(EnemyHuman);
			}
		}
	}
	else{					//C
		float ShotAngle;
		if( longattack == false ){
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = (float)M_PI/180*8;
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = (float)M_PI/180*6;
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = (float)M_PI/180*4;
				}
			}

			//AIxƂɒ
			ShotAngle += (float)M_PI/180*0.5f * LevelParam->limitserror;

			if( movemode == AI_RUN2 ){
				ShotAngle *= 1.5f;
			}
		}
		else{
			//G𑨂Ɣ肷Ae덷vZ
			ShotAngle = (float)M_PI/180*4;
			if( weaponid != ID_WEAPON_NONE ){
				WeaponParameter wparam;
				Param->GetWeapon(weaponid, &wparam);
				if( wparam.scopemode == 1 ){
					ShotAngle = (float)M_PI/180*3;
				}
				if( wparam.scopemode == 2 ){
					ShotAngle = (float)M_PI/180*2;
				}
			}

			//AIxƂɒ
			ShotAngle += (float)M_PI/180*0.2f * LevelParam->limitserror;
		}

		//G𑨂Ă
		float atanxy = atan + atan2(y, r);
		if( atanxy < ShotAngle ){
			int rand = LevelParam->attack;
			if( longattack == true ){ rand += 1; }

			//C
			if( random(rand) == 0 ){
				ObjMgr->ShotWeapon(ctrlhuman);
			}
		}
	}

	//ɉċߋE؂ւ
	//@200.0fsb^Őݒlێ
	if( r < 200.0f * 200.0f ){
		longattack = false;
	}
	if( (r > 200.0f * 200.0f)&&(movemode != AI_RUN2) ){
		longattack = true;
	}

	if( zombie == false ){
		//_Ɉړ
		MoveRandom();
	}

	actioncnt += 1;
}

//! ULZ
bool AIcontrol::ActionCancel()
{
	//GSI
	if( enemyhuman->GetDeadFlag() == true ){
		return true;
	}

	//擾
	float tx, ty, tz;
	enemyhuman->GetPosData(&tx, &ty, &tz, NULL);
	float x = posx - tx;
	float y = posy - ty;
	float z = posz - tz;
	float r = sqrt(x*x + y*y + z*z);

	//߂ĂI
	if( (x*x + y*y + z*z) > 620.0f*620.0f ){
		return true;
	}

	if( longattack == false ){
		//Kȃ^C~OœG邩mF
		if( random(40) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( random(550) == 0 ){
			return true;
		}
	}
	else{
		//Kȃ^C~OœG邩mF
		if( random(30) == 0 ){
			//ubNՂĂiȂjȂΏI
			if( CheckLookEnemy(enemyhuman, AI_SEARCH_RX, AI_SEARCH_RY, 620.0f, NULL) == false ){
				return true;
			}
		}

		//IɏI
		if( random(450) == 0 ){
			return true;
		}
	}

	return false;
}

//! 
int AIcontrol::HaveWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);

	//Ă΁Aԍ擾
	if( weapon[selectweapon] != NULL ){
		weapon[selectweapon]->GetParamData(&weaponid, NULL, NULL);
	}

	//ĂȂAuP[XvȂ
	if( (weapon[selectweapon] == NULL)||(weaponid == ID_WEAPON_CASE) ){
		//̕w
		int notselectweapon = selectweapon + 1;
		if( notselectweapon == TOTAL_HAVEWEAPON ){ notselectweapon = 0; }

		//ւ
		if( weapon[notselectweapon] != NULL ){
			ctrlhuman->ChangeWeapon();
			return 1;
		}
	}

	return 0;
}

//! ړ]_ɏI
void AIcontrol::CancelMoveTurn()
{
	int forward, back, side, updown, rightleft;

	if( battlemode == AI_ACTION ){			//U
		if( movemode == AI_RUN2 ){				//DIȑ
			DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
			DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
			DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
			DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
			DelFlag(moveturn_mode, AI_CTRL_TURNUP);
			DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
			DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
			DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
			if( random(3) == 0 ){
				DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
			}
			return;
		}
		else{									//DIȑ ȊO
			if( longattack == false ){
				forward = 6;
				back = 6;
				side = 7;
				updown = 5;
				rightleft = 6;
			}
			else{
				forward = 5;
				back = 4;
				side = 5;
				updown = 3;
				rightleft = 3;
			}
		}
	}
	else if( battlemode == AI_CAUTION ){	//x
		forward = 10;
		back = 10;
		side = 10;
		updown = 14;
		rightleft = 20;
	}
	else{
		forward = 12;
		back = 12;
		side = 12;
		updown = 15;
		rightleft = 18;
	}

	//ړ_Ɏ~߂
	if( random(forward) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEFORWARD);
	}
	if( random(back) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD);
	}
	if( random(side) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVELEFT);
	}
	if( random(side) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVERIGHT);
	}
	if( random(3) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_MOVEWALK);
	}

	//]_Ɏ~߂
	if( random(updown) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNUP);
	}
	if( random(updown) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}
	if( random(rightleft) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
	if( random(rightleft) == 0 ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
}

//! ړ]s
void AIcontrol::ControlMoveTurn()
{
	//ړ̎s
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEFORWARD) ){
		ctrlhuman->SetMoveForward();
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEBACKWARD) ){
		ctrlhuman->SetMoveBack();
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVELEFT) ){
		ctrlhuman->SetMoveLeft();
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVERIGHT) ){
		ctrlhuman->SetMoveRight();
	}
	if( GetFlag(moveturn_mode, AI_CTRL_MOVEWALK) ){
		ctrlhuman->SetMoveWalk();
	}

	//]̎s
	if( GetFlag(moveturn_mode, AI_CTRL_TURNUP) ){
		ry += AI_TURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNDOWN) ){
		ry -= AI_TURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNLEFT) ){
		rx -= AI_TURNRAD;
	}
	if( GetFlag(moveturn_mode, AI_CTRL_TURNRIGHT) ){
		rx += AI_TURNRAD;
	}
}

//! [hÊĂ
//! @return ̂ĂF1@[hF2@ւF3@ȂF0
int AIcontrol::ControlWeapon()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, lnbs, nbs;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//̏擾
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	if( weapon[selectweapon] == NULL ){ return 0; }
	weapon[selectweapon]->GetParamData(&weaponid, &lnbs, &nbs);

	//XR[v
	ctrlhuman->SetDisableScope();

	//uP[XvȂ牽Ȃ
	if( weaponid == ID_WEAPON_CASE ){ return 0; }

	//퓬ɃOl[hĂ
	if( battlemode == AI_ACTION ){
		if( weaponid == ID_WEAPON_GRENADE ){
			int nextselectweapon, nextnds;

			//̒̕e擾
			nextselectweapon = selectweapon + 1;
			nextnds = 0;
			if( nextselectweapon == TOTAL_HAVEWEAPON ){
				nextselectweapon = 0;
			}
			if( weapon[nextselectweapon] != NULL ){
				weapon[nextselectweapon]->GetParamData(NULL, NULL, &nextnds);
			}

			if( longattack == false ){
				// 1/100̊mŎւ
				if( (random(100) == 0)&&(nextnds > 0) ){
					ctrlhuman->ChangeWeapon();
					return 3;
				}
			}
			else{
				// 1/66̊mŎւ
				if( (random(66) == 0)&&(nextnds > 0) ){
					ctrlhuman->ChangeWeapon();
					return 3;
				}
			}
		}
	}

	//ce
	if( lnbs == 0 ){
		int ways;

		//m
		if( battlemode == AI_NORMAL ){ ways = 1; }
		else if( battlemode == AI_CAUTION ){ ways = 10; }
		else{ ways = 8; }

		// 1/ways̊mŏ
		if( random(ways) == 0 ){
			int under;

			//[hm
			if( battlemode == AI_NORMAL ){
				ways = 1;
				under = 0;
			}
			else if( battlemode == AI_CAUTION ){
				ways = 5;
				under = 3;
			}
			else{
				if( longattack == false ){
					// ḿ@3/4
					ways = 4;
					under = 2;
				}
				else{
					// ḿ@2/3
					ways = 3;
					under = 1;
				}
			}

			//eΎ̂Ă
			if( nbs == 0 ){
				ctrlhuman->DumpWeapon();
				return 1;
			}

			//_ [hs or 
			if( random(ways) <= under ){
				ObjMgr->ReloadWeapon(ctrlhuman);
				return 2;
			}
			//else{
				ctrlhuman->ChangeWeapon();
				return 3;
			//}
		}
	}

	return 0;
}

//! ֒e𓊂
//! @return F0@IF1@֒eĂȂF2
int AIcontrol::ThrowGrenade()
{
	int selectweapon;
	class weapon *weapon[TOTAL_HAVEWEAPON];
	int weaponid, nbs, i;

	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		weapon[i] = NULL;
	}

	//֒eĂ邩mF
	ctrlhuman->GetWeapon(&selectweapon, weapon);
	for(i=0; i<TOTAL_HAVEWEAPON; i++){
		if( weapon[i] != NULL ){
			weapon[i]->GetParamData(&weaponid, NULL, &nbs);
			if( weaponid == ID_WEAPON_GRENADE ){
				break;
			}
		}
	}
	if( i == TOTAL_HAVEWEAPON ){
		return 2;
	}

	//֒eĂȂ΁A؂ւ
	if( i != selectweapon ){
		ctrlhuman->ChangeWeapon(i);
	}

	pointdata pdata;
	float posy2;

	//pXƐl̍擾
	Points->Getdata(&pdata, target_pointid);
	posy2 = posy + VIEW_HEIGHT;

	float x = posx - target_posx;
	float y = pdata.y - posy2;
	float z = posz - target_posz;
	float r = x * x + z * z;
	float atan_rx, atan_ry;

	//ڕWn_ւ̊px߂
	atan_rx = atan2(x, z) - rx + (float)M_PI;
	for(; atan_rx > (float)M_PI; atan_rx -= (float)M_PI*2){}
	for(; atan_rx < (float)M_PI*-1; atan_rx += (float)M_PI*2){}
	atan_ry = atan2(y, sqrt(r)) - ry;

	//傫ȍΏÂ񂷂邾
	if( atan_rx > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
	}
	if( atan_rx < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNLEFT);
	}
	if( atan_ry > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNUP);
	}
	if( atan_ry < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}

	//X鍷ȂCɌ
	if( (atan_rx <= AI_TURNRAD) && (atan_rx >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNRIGHT);
		DelFlag(moveturn_mode, AI_CTRL_TURNLEFT);
		rx += atan_rx;
	}
	if( (atan_ry <= AI_TURNRAD) && (atan_ry >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNUP);
		DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		ry += atan_ry;
	}

	//
	if( (abs(atan_rx) < (float)M_PI/1800*15)&&(abs(atan_ry) < (float)M_PI/1800*15) ){
		//pxݒ
		ctrlhuman->SetRxRy(rx, ry);

		if( ObjMgr->ShotWeapon(ctrlhuman) != 0 ){
			return 1;
		}
	}

	return 0;
}

//! r̊pxݒ
void AIcontrol::ArmAngle()
{
	float addry;

	if( ctrlhuman->GetMainWeaponTypeNO() == ID_WEAPON_NONE ){	//Ԃ
		addry = ARMRAD_NOWEAPON - ry;
	}
	else if( (battlemode == AI_CAUTION)&&(cautioncnt > 0) ){	//x
		addry = 0.0f - ry;
	}
	else{									//펞ŕ폊L
		addry = AI_WEAPON_ARMRAD - ry;
	}

	//傫ȍΏÂ񂷂邾
	if( addry > AI_TURNRAD ){
		SetFlag(moveturn_mode, AI_CTRL_TURNUP);
	}
	if( addry < AI_TURNRAD*-1 ){
		SetFlag(moveturn_mode, AI_CTRL_TURNDOWN);
	}

	//X鍷ȂCɌ
	if( (addry <= AI_TURNRAD) && (addry >= AI_TURNRAD*-1) ){
		DelFlag(moveturn_mode, AI_CTRL_TURNUP);
		DelFlag(moveturn_mode, AI_CTRL_TURNDOWN);
		ry += addry;
	}
}

//! GT
int AIcontrol::SearchEnemy()
{
	if( battlemode == AI_ACTION ){ return 0; }

	int weaponid = ctrlhuman->GetMainWeaponTypeNO();
	int weaponscope = 0;
	int searchloops;
	float maxDist;
	float A_rx, A_ry, B_rx, B_ry;

	//Ă΁AXR[v[h擾
	if( weaponid != ID_WEAPON_NONE ){
		WeaponParameter Wparam;

		Param->GetWeapon(weaponid, &Wparam);
		weaponscope = Wparam.scopemode;
	}

	//G̒T񐔂ƒT͈́iƊpxjݒ
	if( battlemode == AI_NORMAL ){
		searchloops = (LevelParam->search) * 4;

		if( weaponscope == 2 ){ maxDist = 50.0f; }
		if( weaponscope == 1 ){ maxDist = 25.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 12.0f*((LevelParam->search)-2) + 350.0f;
		A_rx = (float)M_PI/180*60;
		A_ry = (float)M_PI/180*110;
		B_rx = (float)M_PI/180*40;
		B_ry = (float)M_PI/180*60;
	}
	else {	//battlemode == AI_CAUTION
		searchloops = (LevelParam->search) * 5;

		if( weaponscope == 2 ){ maxDist = 80.0f; }
		if( weaponscope == 1 ){ maxDist = 40.0f; }
		else{ maxDist = 0.0f; }
		maxDist += 15.0f*((LevelParam->search)-2) + 420.0f;
		A_rx = (float)M_PI/180*80;
		A_ry = (float)M_PI/180*130;
		B_rx = (float)M_PI/180*50;
		B_ry = (float)M_PI/180*80;
	}

	//w񐔁AGT
	for(int i=0; i<searchloops; i++){
		int targetid = random(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}

		if( CheckLookEnemy(targetid, B_rx, B_ry, maxDist, NULL) == true ){
			if( random(4) == 0 ){
				if( movemode == AI_RUN2 ){ longattack = false; }
				else{ longattack = true; }
				return 2;
			}
		}
	}
	return 0;
}

//! GTiUɋߋTj
int AIcontrol::SearchShortEnemy()
{
	float A_rx, A_ry;
	A_rx = (float)M_PI/180*100;
	A_ry = (float)M_PI/180*52;

	for(int i=0; i<3; i++){
		int targetid = random(MAX_HUMAN);

		if( CheckLookEnemy(targetid, A_rx, A_ry, 200.0f, NULL) == true ){
			longattack = false;
			return 1;
		}
	}
	return 0;
}

//! G邩
bool AIcontrol::CheckLookEnemy(int id, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	if( ObjMgr == NULL ){ return false; }

	//l̃IuWFNg擾
	class human* thuman;
	thuman = ObjMgr->GeHumanObject(id);
	if( thuman == NULL ){ return false; }

	//֐I[o[[h
	return CheckLookEnemy(thuman, search_rx, search_ry, maxDist, out_minDist);
}

//! G邩
bool AIcontrol::CheckLookEnemy(class human* thuman, float search_rx, float search_ry, float maxDist, float *out_minDist)
{
	//return false;

	//ȃf[^ȂI
	if( ctrlhuman == NULL ){ return false; }
	if( thuman == NULL ){ return false; }
	if( thuman->GetDrawFlag() == false ){ return false; }
	if( thuman->GetDeadFlag() == true ){ return false; }

	//ƓG̍W擾
	int ctrlteam, targetteam;
	float tx, ty, tz;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
	thuman->GetParamData(NULL, NULL, NULL, &targetteam);
	thuman->GetPosData(&tx, &ty, &tz, NULL);

	//ƓGlłȂ
	if( ctrlteam != targetteam ){
		float Dist;
		float Dist_dummy; 
		float x, y, z;

		//擾
		x = tx - posx;
		y = ty - posy;
		z = tz - posz;
		Dist = sqrt(x*x + y*y + z*z);

		//s߂
		if( Dist < maxDist ){
			float rx2, trx, mrx;

			//ľE_߂@i0.0`2΁j
			rx2 = rx*-1 + (float)M_PI/2;
			for(; rx2 > (float)M_PI*2; rx2 -= (float)M_PI*2){}
			for(; rx2 < 0.0f; rx2 += (float)M_PI*2){}

			//|Cg܂ł̊px߂@i0.0`2΁j
			trx = atan2(z, x);
			if( trx < 0.0f ){ trx += (float)M_PI*2; }

			//_Ƀ|Cg܂ł̊pxZoi-΁`΁j
			mrx = trx - rx2;
			for(; mrx > (float)M_PI; mrx -= (float)M_PI*2){}
			for(; mrx < (float)M_PI*-1; mrx += (float)M_PI*2){}

			//pxAEɓĂ
			if( (abs(mrx) < search_rx/2)&&(abs(atan2(y, sqrt(x*x + z*z))) < search_ry/2) ){
				//ubNՂĂȂ΁@iCœ蔻sAĂȂ΁j
				if( CollD->CheckALLBlockIntersectRay(posx, posy + VIEW_HEIGHT, posz, x/Dist, y/Dist, z/Dist, NULL, NULL, &Dist_dummy, Dist) == false ){
					if( out_minDist != NULL ){ *out_minDist = Dist; }
					enemyhuman = thuman;
					return true;
				}
			}
		}
	}
	return false;
}

//! ̂邩mF
bool AIcontrol::CheckCorpse(int id)
{
	//NXݒ肪ΏȂ
	if( ObjMgr == NULL ){ return false; }
	if( ctrlhuman == NULL ){ return false; }

	//^[Qbg̃NX擾
	class human* thuman;
	thuman = ObjMgr->GeHumanObject(id);
	if( thuman == NULL ){ return false; }
	if( thuman->GetDrawFlag() == false ){ return false; }

	//SĂ
	if( thuman->GetDeadFlag() == true ){

		//`[ԍ擾
		int ctrlteam, targetteam;
		ctrlhuman->GetParamData(NULL, NULL, NULL, &ctrlteam);
		thuman->GetParamData(NULL, NULL, NULL, &targetteam);

		//Ȃ
		if( ctrlteam == targetteam ){
			float tposx, tposy, tposz;
			float x, y, z, r;
			float atan;

			//W狗擾
			thuman->GetPosData(&tposx, &tposy, &tposz, NULL);
			x = posx - tposx;
			y = posy - tposy;
			z = posz - tposz;
			r = x*x + y*y + z*z;

			if( r < 22.0f * 22.0f ){
				//̂ւ̊px߂
				atan = atan2(x, z) - rx + (float)M_PI;
				for(; atan > (float)M_PI; atan -= (float)M_PI*2){}
				for(; atan < (float)M_PI*-1; atan += (float)M_PI*2){}

				if( abs(atan) < (float)M_PI/18*4 ){
					return true;
				}
			}
		}
	}
	return false;
}

//! pXɂړ
void AIcontrol::MovePath()
{
	if( movemode == AI_NULL ){			//ُȃpX
		//
	}
	else if( movemode == AI_GRENADE ){	//֒epX
		if( ThrowGrenade() != 0 ){
			SearchTarget(true);
		}
	}
	else{								//̑pX
		if( CheckTargetPos() == false ){
			MoveTarget();
		}
		else if( (movemode == AI_WAIT)||(movemode == AI_TRACKING) ){
			TurnSeen();
		}
		else if( (movemode == AI_STOP)&&(waitcnt < ((int)GAMEFPS)*5) ){
			if( StopSeen() == true ){
				waitcnt += 1;
			}
		}
		else{
			waitcnt = 0;
			SearchTarget(true);
		}
	}
}

//! UC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::ActionMain()
{
	int newbattlemode = AI_ACTION;

	//U
	Action();

	if( movemode == AI_RUN2 ){				//DIȑ
		//ڕWn_ֈړ
		if( CheckTargetPos() == true ){
			newbattlemode = AI_NORMAL;
			SearchTarget(true);
		}
		else{
			MoveTarget2();
		}
	}
	else{									//DIȑ ȊO
		//UȂA߂̓GT
		if( longattack == true ){
			SearchShortEnemy();
		}
	}

	//UI
	if( ActionCancel() == true ){
		enemyhuman = NULL;

		if( movemode == AI_RUN2 ){
			newbattlemode = AI_NORMAL;
		}
		else{
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! xC
//! @return sρFfalse@ύXFtrue
bool AIcontrol::CautionMain()
{
	int newbattlemode = AI_CAUTION;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit();
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//]Ƙr̊px
	TurnSeen();
	ArmAngle();

	//C
	if( enemyhuman != NULL ){		//ɓGĂ
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( SearchEnemy() != 0 ){		//G
		newbattlemode = AI_ACTION;
		actioncnt = 0;
	}
	else if( (HitFlag == true)||(soundlists > 0) ){	//e
		cautioncnt = 160;			//xĊJ
	}
	else if( cautioncnt == 0 ){		//xIȂ
		if( CheckTargetPos() == false ){				//xJnn_藣Ă邩
			MoveTarget();				//xJnn_ɋ߂Â
		}
		else{
			newbattlemode = AI_NORMAL;

			//x҂pXȂ玟֐i߂
			pointdata pdata;
			Points->Getdata(&pdata, target_pointid);
			if( (pdata.p1 == 3)&&(pdata.p2 == 4) ){
				SearchTarget(true);
			}
		}
	}
	else if( cautioncnt < 100 ){	//100t[؂A_ɌxIiJEgF0Ɂj
		if( random(50) == 0 ){ cautioncnt = 0; }
	}
	else{ cautioncnt -= 1; }

	//ǔőΏۂ痣ꂷA_ɌxI
	if( (movemode == AI_TRACKING)&&(random(3) == 0) ){
		pointdata pdata;
		float x, z;
		float tx, tz;
		Points->Getdata(&pdata, target_pointid);
		SearchHumanPos(pdata.p4, &tx, &tz);
		x = posx - tx;
		z = posz - tz;
		if( (x*x + z*z) > 25.0f*25.0f ){
			cautioncnt = 0;
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! ʏ탁C
//! @return sρFfalse@ύXFtrue
bool AIcontrol::NormalMain()
{
	int newbattlemode = AI_NORMAL;

	if( hold == false ){
		SearchTarget(false);
	}
	enemyhuman = NULL;

	//Wƃ`[ԍ擾
	int teamid;
	ctrlhuman->GetParamData(NULL, NULL, NULL, &teamid);

	//eƉ̏󋵂擾
	bool HitFlag = ctrlhuman->CheckHit();
	soundlist soundlist[MAX_SOUNDMGR_LIST];
	int soundlists = GameSound->GetWorldSound(posx, posy + VIEW_HEIGHT, posz, teamid, soundlist);

	//_pXȂ珈s
	if( movemode == AI_RANDOM ){
		SearchTarget(true);
	}

	//r̊pxݒ
	if( movemode != AI_GRENADE ){
		ArmAngle();
	}

	if( movemode == AI_RUN2 ){		//DIȑ̏
		//GUɓ
		if( SearchEnemy() != 0 ){
			newbattlemode = AI_ACTION;
		}
		else{
			MovePath();		//ړs
		}
	}
	else{							//DIȑȊȌ
		//xɓ鏈
		if(
			(SearchEnemy() != 0)||							//G
			(HitFlag == true)||(soundlists > 0)||	//e
			(CheckCorpse( random(MAX_HUMAN) ) == true)	//̂
		){
			newbattlemode = AI_CAUTION;
			cautioncnt = 160;
			target_posx = posx;
			target_posz = posz;
		}
		else{
			MovePath();		//ړs
		}
	}

	//ݒ𔻒
	if( battlemode != newbattlemode ){
		battlemode = newbattlemode;
		return true;
	}
	return false;
}

//! n֐
void AIcontrol::Init()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( Points == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//gpĂȂlȂ珈Ȃ
	if( ctrlhuman->GetDrawFlag() == false ){ return; }

	//Xe[g
	hold = false;
	battlemode = AI_NORMAL;
	movemode = AI_NULL;
	enemyhuman = NULL;
	waitcnt = 0;
	gotocnt = 0;
	moveturn_mode = 0x00;
	cautioncnt = 0;
	actioncnt = 0;
	longattack = false;

	//AIxƐݒl擾
	int paramid;
	HumanParameter paramdata;
	//target_pointid = in_target_pointid;
	ctrlhuman->GetParamData(&paramid, &target_pointid, NULL, NULL);
	Param->GetHuman(paramid, &paramdata);
	AIlevel = paramdata.AIlevel;
	Param->GetAIlevel(AIlevel, &LevelParam);

	//̃|Cg
	SearchTarget(true);
}

//! w肵ꏊ֑ҋ@
//! @param px XW
//! @param pz ZW
//! @param rx d
//! @attention ړpXɊւ炸Aw肵Wւ̑ҋ@܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldWait(float px, float pz, float rx)
{
	movemode = AI_WAIT;
	hold = true;
	target_posx = px;
	target_posz = pz;
	target_rx = rx;
}

//! w肵lǔ
//! @param id l̃f[^ԍ
//! @attention ړpXɊւ炸Aw肵lւ̒ǔ܂BInit()֐ēxs܂Ōɖ߂܂B
void AIcontrol::SetHoldTracking(int id)
{
	movemode = AI_TRACKING;
	hold = false;
	target_pointid = id;
}

//! n֐
void AIcontrol::Process()
{
	//NXݒ肪ΏȂ
	if( ctrlhuman == NULL ){ return; }
	if( blocks == NULL ){ return; }
	if( Points == NULL ){ return; }
	if( CollD == NULL ){ return; }

	//ȐlNXȂ珈Ȃ
	if( ctrlhuman->GetDrawFlag() == false ){ return; }

	//S
	if( ctrlhuman->GetHP() <= 0 ){
		battlemode = AI_DEAD;
		movemode = AI_DEAD;
		return;
	}

	//WƊpx擾
	ctrlhuman->GetPosData(&posx, &posy, &posz, NULL);
	ctrlhuman->GetRxRy(&rx, &ry);

	//_ɓ~߂
	CancelMoveTurn();

	//UxȂ
	if( (battlemode == AI_ACTION)||(battlemode == AI_CAUTION) ){
		//
		HaveWeapon();
	}

	//vZs
	if( battlemode == AI_ACTION ){			//U
		ActionMain();
	}
	else if( battlemode == AI_CAUTION ){	//x
		CautionMain();
	}
	else{									//펞
		NormalMain();
	}

	//ړE]
	ControlMoveTurn();

	//舵
	ControlWeapon();

	//pxKp
	ctrlhuman->SetRxRy(rx, ry);
}