//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2023, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

//O[oϐ
float4x4 WorldVertexPos;	//fW
float4x4 WorldViewPos;		//JW
float4x4 WorldViewProj;		//ϊs
float4   Diffuse;		//fBt[YF
float4   ViewPos;		//JWigpj
bool     Enable2DRendering;	//2D`tOigpj
bool     EnableTexture;		//eNX`tO
bool     EnableFog;		//tHOLtO
float4   FogColor;		//tHOF
float    FogStart;		//tHO̊Jn[x
float    FogEnd;		//tHȌI[x

// _VF[_[̊֐
void VertexShader_Main(
	in  float4 inPos      : POSITION,	//[] W(f)
	in  float4 inDiff     : COLOR0,		//[] F
	in  float4 inTexture  : TEXCOORD0,	//[] eNX`W

	out float4 outPos      : POSITION,	//[o] W(ˉe)
	out float4 outDiff     : COLOR0,	//[o] F
	out float4 outTexture  : TEXCOORD0,	//[o] eNX`W
	out float4 outPosWorld : TEXCOORD1,	//[o] W([hW)
	out float4 outPosView  : TEXCOORD2)	//[o] W(ˉe)
{
	float4 VertexPos = mul(inPos, WorldVertexPos);

	outPos = mul(mul(VertexPos, WorldViewPos), WorldViewProj);	//_ƕϊs|
	outDiff = max(inDiff, Diffuse);					//F߂
	outTexture = inTexture;						//eNX`W͂̂܂
	outPosWorld = VertexPos;					//[hŴ܂܏o
	outPosView = outPos;						//ˉeԂ̂܂܏o
}


texture Tex;				//sNZVF[_[ŎgeNX`
sampler TexSampler = sampler_state	//eNX`ETv
{
	Texture   = (Tex);
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
};

//sNZVF[_[
void PixelShader_Main(
	in  float4 inDiff     : COLOR0,		//[] F
	in  float2 inTexture  : TEXCOORD0,	//[] eNX`W
	in  float4 inWorldPos : TEXCOORD1,	//[] [hW
	in  float4 inViewPos  : TEXCOORD2,	//[] ˉe

	out float4 outDiff    : COLOR0)		//[o] F
{
	if( EnableTexture == true ){
		outDiff = inDiff * tex2D(TexSampler, inTexture);
	}
	else{
		outDiff = inDiff;
	}

	//tHOvZ
	if( EnableFog == true ){
		float fog;
		fog = max(0.0f, (inViewPos.z - FogStart)/(FogEnd - FogStart));
		outDiff.rgb = lerp(outDiff.rgb, FogColor.rgb, fog);			//D3DFOG_LINEAR
		//outDiff.rgb = lerp(outDiff.rgb, FogColor.rgb, pow(fog, 2.0f));	//D3DFOG_EXP2
	}
}
