//! @file config.cpp
//! @brief configNX̒` 

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2023, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "config.h"

//! @brief RXgN^
Config::Config()
{
	//e탁o[ϐ
	for(int i=0; i<TOTAL_ControlKey; i++){
		Keycode[i] = 0;
	}
	MouseSensitivity = 0;
	FullscreenFlag = false;
	SoundFlag = false;
	BloodFlag = false;
	Brightness = 0;
	InvertMouseFlag = false;
	FrameskipFlag = false;
	AnotherGunsightFlag = false;
	strcpy(PlayerName, "");

	Language = 0;
	ShowArmFlag = false;
	ScreenWidth = 0;
	ScreenHeight = 0;
	MouseLimitFlag = true;
	mastervolume = 0.0f;
}

//! @brief fBXgN^
Config::~Config()
{}

//! @brief ݒt@Cǂݍ
//! @param fname t@C
//! @return F0@sF1
int Config::LoadFile(const char *fname)
{
	if( fname == NULL ){ return 1; }

	FILE *fp;
	char buf;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Config File", fname);
#endif

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	//t@CJ
	fp = fopen(fname, "rb");
	if( fp == NULL ){ return 1; }

	//L[R[h
	for(int i=0; i<TOTAL_ControlKey; i++){
		fread(&buf, 1, 1, fp);
		Keycode[i] = (int)buf;
	}

	//}EXx
	fread(&buf, 1, 1, fp);
	MouseSensitivity = (int)buf;

	//tXN[L
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ FullscreenFlag = false; }
	else{ FullscreenFlag = true; }

	//ʉL
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ SoundFlag = false; }
	else{ SoundFlag = true; }

	//oL
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ BloodFlag = false; }
	else{ BloodFlag = true; }

	//ʂ̖邳
	fread(&buf, 1, 1, fp);
	Brightness = (int)buf;

	//}EX]
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ InvertMouseFlag = false; }
	else{ InvertMouseFlag = true; }

	//t[XLbv
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ FrameskipFlag = false; }
	else{ FrameskipFlag = true; }

	//ʂ̏Əgp
	fread(&buf, 1, 1, fp);
	if( buf == 0x00 ){ AnotherGunsightFlag = false; }
	else{ AnotherGunsightFlag = true; }

	//vC[
	fread(PlayerName, 1, MAX_PLAYERNAME, fp);

	//t@Cnh
	fclose(fp);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
	return 0;
}

//! @brief ݒt@Cɏ
//! @param fname t@C
//! @return F0@sF1
int Config::SaveFile(const char *fname)
{
	if( fname == NULL ){ return 1; }

	FILE *fp;
	char buf;

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Config File (Save)", fname);
#endif

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	//t@CJ
	fp = fopen(fname, "wb");
	if( fp == NULL ){ return 1; }

	//L[R[h
	for(int i=0; i<TOTAL_ControlKey; i++){
		buf = (char)Keycode[i];
		fwrite(&buf, 1, 1, fp);
	}

	//}EXx
	buf = (char)MouseSensitivity;
	fwrite(&buf, 1, 1, fp);

	//tXN[L
	if( FullscreenFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//ʉL
	if( SoundFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//oL
	if( BloodFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//ʂ̖邳
	buf = (char)Brightness;
	fwrite(&buf, 1, 1, fp);

	//}EX]
	if( InvertMouseFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//t[XLbv
	if( FrameskipFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//ʂ̏Əgp
	if( AnotherGunsightFlag == false ){ buf = 0x00; }
	else{ buf = 0x01; }
	fwrite(&buf, 1, 1, fp);

	//vC[
	fwrite(PlayerName, 1, MAX_PLAYERNAME, fp);

	//t@Cnh
	fclose(fp);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
	return 0;
}

//! @brief ݒlftHg̒lŏ
void Config::SetDefaultConfig()
{
	Keycode[KEY_TURNUP]			= 0;
	Keycode[KEY_TURNDOWN]		= 1;
	Keycode[KEY_TURNLEFT]		= 2;
	Keycode[KEY_TURNRIGHT]		= 3;
	Keycode[KEY_MOVEFORWARD]	= 54;
	Keycode[KEY_MOVEBACKWARD]	= 50;
	Keycode[KEY_MOVELEFT]		= 32;
	Keycode[KEY_MOVERIGHT]		= 35;
	Keycode[KEY_WALK]			= 16;
	Keycode[KEY_JUMP]			= 17;
	Keycode[KEY_RELOAD]			= 49;
	Keycode[KEY_DROPWEAPON]		= 38;
	Keycode[KEY_ZOOMSCOPE]		= 20;
	Keycode[KEY_SHOTMODE]		= 55;
	Keycode[KEY_SWITCHWEAPON]	= 57;
	Keycode[KEY_WEAPON1]		= 23;
	Keycode[KEY_WEAPON2]		= 24;
	Keycode[KEY_SHOT]			= 18;
	MouseSensitivity = 25;
	FullscreenFlag = true;
	SoundFlag = true;
	BloodFlag = true;
	Brightness = 4;
	InvertMouseFlag = false;
	FrameskipFlag = false;
	AnotherGunsightFlag = false;
	strcpy(PlayerName, "xopsplayer");
}

//! @brief IWiL[R[h擾
//! @param id 萔
//! @return IWiL[R[h
int Config::GetKeycode(int id)
{
	if( (id < 0)||(TOTAL_ControlKey <= id) ){ return 0; }

	return Keycode[id];
}

//! @brief IWiL[R[hݒ
//! @param id 萔
//! @param key IWiL[R[h
void Config::SetKeycode(int id, int key)
{
	if( (id < 0)||(TOTAL_ControlKey <= id) ){ return; }

	Keycode[id] = key;
}

//! @brief }EXx擾
//! @return ̒l
int Config::GetMouseSensitivity()
{
	return MouseSensitivity;
}

//! @brief }EXxݒ
//! @param param ̒l
void Config::SetMouseSensitivity(int param)
{
	MouseSensitivity = param;
}

//! @brief ʕ\[h擾
//! @return EBhEFfalse@tXN[Ftrue
bool Config::GetFullscreenFlag()
{
	return FullscreenFlag;
}

//! @brief ʕ\[hݒ
//! @param flag tO
void Config::SetFullscreenFlag(bool flag)
{
	FullscreenFlag = flag;
}

//! @brief ʉݒ擾
//! @return Ffalse@LFtrue
bool Config::GetSoundFlag()
{
	return SoundFlag;
}

//! @brief ʉݒ
//! @param flag tO
void Config::SetSoundFlag(bool flag)
{
	SoundFlag = flag;
}

//! @brief oݒ擾
//! @return Ffalse@LFtrue
bool Config::GetBloodFlag()
{
	return BloodFlag;
}

//! @brief oݒ
//! @param flag tO
void Config::SetBloodFlag(bool flag)
{
	BloodFlag = flag;
}

//! @brief ʂ̖邳ݒ擾
//! @return ̒l
int Config::GetBrightness()
{
	return Brightness;
}

//! @brief ʂ̖邳ݒ
//! @param param ̒l
void Config::SetBrightness(int param)
{
	Brightness = param;
}


//! @brief }EX]ݒ擾
//! @return Ffalse@LFtrue
bool Config::GetInvertMouseFlag()
{
	return InvertMouseFlag;
}

//! @brief }EX]ݒ
//! @param flag tO
void Config::SetInvertMouseFlag(bool flag)
{
	InvertMouseFlag = flag;
}

//! @brief t[XLbvݒ擾
//! @return Ffalse@LFtrue
bool Config::GetFrameskipFlag()
{
	return FrameskipFlag;
}

//! @brief t[XLbvݒ
//! @param flag tO
void Config::SetFrameskipFlag(bool flag)
{
	FrameskipFlag = flag;
}

//! @brief ʂ̏Əgpݒ擾
//! @return Ffalse@LFtrue
bool Config::GetAnotherGunsightFlag()
{
	return AnotherGunsightFlag;
}

//! @brief ʂ̏Əgpݒ
//! @param flag tO
void Config::SetAnotherGunsightFlag(bool flag)
{
	AnotherGunsightFlag = flag;
}

//! @brief vC[擾
//! @param out_str 󂯎镶^|C^
//! @return vC[
int Config::GetPlayerName(char *out_str)
{
	if( out_str == NULL ){ return 0; }

	//|C^ɃRs[
	strcpy(out_str, PlayerName);

	//Ԃ
	return (int)strlen(PlayerName);
}

//! @brief vC[ݒ
//! @param in_str vC[
void Config::SetPlayerName(char *in_str)
{
	if( in_str == NULL ){ return; }

	if( strlen(in_str) > (MAX_PLAYERNAME - 1) ){
		in_str[MAX_PLAYERNAME - 1] = 0x00;
	}

	//Rs[
	strcpy(PlayerName, in_str);
}

//! @brief IWiL[R[h̖O擾
//! @param code IWiL[R[h
//! @return L[̖O
const char* Config::GetOriginalkeycodeString(int code)
{
	const char *out;

	switch(code){
		case 0x00: out = "UP"; break;
		case 0x01: out = "DOWN"; break;
		case 0x02: out = "LEFT"; break;
		case 0x03: out = "RIGHT"; break;
		case 0x04: out = "NUM0"; break;
		case 0x05: out = "NUM1"; break;
		case 0x06: out = "NUM2"; break;
		case 0x07: out = "NUM3"; break;
		case 0x08: out = "NUM4"; break;
		case 0x09: out = "NUM5"; break;
		case 0x0A: out = "NUM6"; break;
		case 0x0B: out = "NUM7"; break;
		case 0x0C: out = "NUM8"; break;
		case 0x0D: out = "NUM9"; break;
		case 0x0E: out = "BACKSPACE"; break;
		case 0x0F: out = "ENTER"; break;

		case 0x10: out = "TAB"; break;
		case 0x11: out = "SPACE"; break;
		case 0x12: out = "MOUSE L"; break;
		case 0x13: out = "MOUSE R"; break;
		case 0x14: out = "SHIFT"; break;
		case 0x15: out = "CTRL"; break;
		case 0x16: out = "0"; break;
		case 0x17: out = "1"; break;
		case 0x18: out = "2"; break;
		case 0x19: out = "3"; break;
		case 0x1A: out = "4"; break;
		case 0x1B: out = "5"; break;
		case 0x1C: out = "6"; break;
		case 0x1D: out = "7"; break;
		case 0x1E: out = "8"; break;
		case 0x1F: out = "9"; break;

		case 0x20: out = "A"; break;
		case 0x21: out = "B"; break;
		case 0x22: out = "C"; break;
		case 0x23: out = "D"; break;
		case 0x24: out = "E"; break;
		case 0x25: out = "F"; break;
		case 0x26: out = "G"; break;
		case 0x27: out = "H"; break;
		case 0x28: out = "I"; break;
		case 0x29: out = "J"; break;
		case 0x2A: out = "K"; break;
		case 0x2B: out = "L"; break;
		case 0x2C: out = "M"; break;
		case 0x2D: out = "N"; break;
		case 0x2E: out = "O"; break;
		case 0x2F: out = "P"; break;

		case 0x30: out = "Q"; break;
		case 0x31: out = "R"; break;
		case 0x32: out = "S"; break;
		case 0x33: out = "T"; break;
		case 0x34: out = "U"; break;
		case 0x35: out = "V"; break;
		case 0x36: out = "W"; break;
		case 0x37: out = "X"; break;
		case 0x38: out = "Y"; break;
		case 0x39: out = "Z"; break;
		case 0x3A: out = "/"; break;
		case 0x3B: out = ":"; break;
		case 0x3C: out = ";"; break;
		case 0x3D: out = "-"; break;
		case 0x3E: out = "@"; break;
		case 0x3F: out = "["; break;

		case 0x40: out = "]"; break;
		case 0x41: out = "BACKSLASH"; break;
		case 0x42: out = "\\"; break;
		case 0x43: out = ","; break;
		case 0x44: out = "."; break;
		case 0x45: out = "^"; break;
		case 0x46: out = "NUM*" ; break;
		case 0x47: out = "NUM/"; break;
		case 0x48: out = "NUM+"; break;
		case 0x49: out = "NUM-"; break;
		case 0x4A: out = "NUM."; break;

		default : out = "NULL";
	}

	return out;
}


//! @brief ǉݒt@C𐶐
//! @param fname t@C
//! @return Ftrue@s/svFfalse
bool Config::CreateExtConfig(const char *fname)
{
#ifdef ENABLE_ADDCONFIG
	if( fname == NULL ){ return false; }

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	FILE *fp;

	//t@C݂Ȃ玸sit@Csvj
	fp = fopen(fname, "r");
	if( fp != NULL ){
		fclose(fp);
		return false;
	}

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Config File (Create .ini)", fname);
#endif

	fp = fopen(fname, "w");
	if( fp == NULL ){ return false; }

	fprintf(fp, "[Game]\n");
	fprintf(fp, ";Game language.\n");
	fprintf(fp, ";  0: English + Japanese  (default)\n");
	fprintf(fp, ";  1: English + Korean\n");
	fprintf(fp, "Language = 0\n");
	fprintf(fp, "\n");
	fprintf(fp, ";Show player arm and weapon.\n");
	fprintf(fp, ";  0: OFF (default)\n");
	fprintf(fp, ";  1: ON\n");
	fprintf(fp, "ShowArm = 0\n");
	fprintf(fp, "\n");
	fprintf(fp, "\n");

	fprintf(fp, "[Graphics]\n");
	fprintf(fp, ";WindowSize\n");
	fprintf(fp, ";  0: 640x480  [4:3] (default)\n");
	fprintf(fp, ";  1: 800x600  [4:3]\n");
	fprintf(fp, ";  2:1024x768  [4:3]\n");
	fprintf(fp, ";  3:1280x960  [4:3]\n");
	fprintf(fp, ";  4:1600x1200 [4:3]\n");
	fprintf(fp, "; 10:1280x720  [16:9]\n");
	fprintf(fp, "; 11:1600x900  [16:9]\n");
	fprintf(fp, "; 12:1920x1080 [16:9]\n");
	//fprintf(fp, "; 13:2560x1440 [16:9]\n");
	//fprintf(fp, "; 14:3840x2160 [16:9]\n");
	fprintf(fp, "WindowSize = 0\n");
	fprintf(fp, "\n");
	fprintf(fp, "\n");

	fprintf(fp, "[Input]\n");
	fprintf(fp, ";Limit mouse input control.\n");
	fprintf(fp, ";  0: OFF\n");
	fprintf(fp, ";  1: ON (default)\n");
	fprintf(fp, "MouseLimit = 1\n");
	fprintf(fp, "\n");
	fprintf(fp, "\n");

	fprintf(fp, "[Sounds]\n");
	fprintf(fp, ";Game sound volume. (0.0 ~ 1.0)\n");
	fprintf(fp, "MasterVolume = 1.0\n");
	fprintf(fp, "\n");

	fclose(fp);

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif
	return true;
#else
	return false;
#endif
}

//! @brief ǉݒt@Cǂݍ
//! @param fname t@C
//! @return F0@sF1
int Config::LoadExtFile(const char *fname)
{
#ifdef ENABLE_ADDCONFIG
	if( fname == NULL ){ return 1; }

	INIFileInterface INIConfig;
	int mode;
	
#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_LOAD, "Config File (.ini)", fname);
#endif

#ifdef ENABLE_PATH_DELIMITER_SLASH
	//pX؂蕶ϊ
	fname = ChangePathDelimiter(fname);
#endif

	INIConfig.LoadINIFile(fname);

	//\擾
	Language = INIConfig.GetINIFileInt("Game", "Language", 0, NULL);

	//r\tO擾
	mode = INIConfig.GetINIFileInt("Game", "ShowArm", 0, NULL);
	if( mode == 0 ){ ShowArmFlag = false; }
	else{ ShowArmFlag = true; }

	//𑜓x擾
	mode = INIConfig.GetINIFileInt("Graphics", "WindowSize", 0, NULL);
	switch(mode){
		case  0: ScreenWidth =  640; ScreenHeight =  480; break;
		case  1: ScreenWidth =  800; ScreenHeight =  600; break;
		case  2: ScreenWidth = 1024; ScreenHeight =  768; break;
		case  3: ScreenWidth = 1280; ScreenHeight =  960; break;
		case  4: ScreenWidth = 1600; ScreenHeight = 1200; break;
		case 10: ScreenWidth = 1280; ScreenHeight =  720; break;
		case 11: ScreenWidth = 1600; ScreenHeight =  900; break;
		case 12: ScreenWidth = 1920; ScreenHeight = 1080; break;
		case 13: ScreenWidth = 2560; ScreenHeight = 1440; break;
		case 14: ScreenWidth = 3840; ScreenHeight = 2160; break;
		default: ScreenWidth = DEFAULT_SCREEN_WIDTH; ScreenHeight = DEFAULT_SCREEN_HEIGHT; break;
	}

	//}EXړʐtO
	mode = INIConfig.GetINIFileInt("Input", "MouseLimit", 1, NULL);
	if( mode == 0 ){ MouseLimitFlag = false; }
	else{ MouseLimitFlag = true; }

	//ʎ擾
	mastervolume = INIConfig.GetINIFileFloat("Sounds", "MasterVolume", 1.0f, NULL);
	if( mastervolume < 0.0f ){ mastervolume = 0.0f; }
	if( mastervolume > 1.0f ){ mastervolume = 1.0f; }

	INIConfig.ReleaseINIFile();

#ifdef ENABLE_DEBUGLOG
	//Oɏo
	OutputLog.WriteLog(LOG_COMPLETE, "", "");
#endif

#else
	ShowArmFlag = false;
	ScreenWidth = DEFAULT_SCREEN_WIDTH;
	ScreenHeight = DEFAULT_SCREEN_HEIGHT;
	mastervolume = 1.0f;
#endif
	return 0;
}

//! @brief ǉݒlftHg̒lŏ
void Config::SetDefaultExtConfig()
{
	Language = 0;
	ShowArmFlag = false;
	ScreenWidth = DEFAULT_SCREEN_WIDTH;
	ScreenHeight = DEFAULT_SCREEN_HEIGHT;
	MouseLimitFlag = true;
	mastervolume = 1.0f;
}

//! @brief ݒ擾
//! @return l
int Config::GetLanguage()
{
	return Language;
}

//! @brief r\tO擾
//! @return tO
bool Config::GetShowArmFlag()
{
	return ShowArmFlag;
}

//! @brief ʉ𑜓xij擾
//! @return l
int Config::GetScreenWidth()
{
	return ScreenWidth;
}

//! @brief ʉ𑜓xij擾
//! @return l
int Config::GetScreenHeight()
{
	return ScreenHeight;
}

//! @brief }EXړʐtO
//! @return l
bool Config::GetMouseLimitFlag()
{
	return MouseLimitFlag;
}

//! @brief ʐݒ擾
//! @return l
float Config::GetVolume()
{
	return mastervolume;
}
