//! @file d3dgraphics.h
//! @brief D3DGraphicsNX̐錾

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

// ***** OpenGL core only *****
//
// libjpeg
//    Copyright (C) 1991-2014, Thomas G. Lane, Guido Vollbeding.
//    this software is based in part on the work of the Independent JPEG Group
//
// zlib
//    Copyright (C) 1995-2013 Jean-loup Gailly and Mark Adler
//
// libpng
//    Copyright (c) 1998-2014 Glenn Randers-Pehrson
//
// ****************************

#ifndef D3DGRAPHICS_H
#define D3DGRAPHICS_H

#define MAX_MODEL 72		//!< ő僂f
#define MAX_TEXTURE 72		//!< őeNX`

#define CLIPPINGPLANE_NEAR 1.0f		//!< ߃Nbvʁi`悷ŏj
#define CLIPPINGPLANE_FAR 800.0f	//!< Nbvʁi`悷ő勗j

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 1		//!< Select include file.
#endif
#include "main.h"

//! @brief gpOtBbNXRȂI
//! @details DirectX 9.0ciŒpCvCjF0@DirectX 9.0ciVF[_[jF1@OpenGL 1.1F8
//! @attention DirectX 9.0c̃VF[_[gꍇA"resource.rc"ҏWĂB
#define GRAPHIC_ENGINE 0

#if (GRAPHIC_ENGINE == 0)||(GRAPHIC_ENGINE == 1)

#define BLOCKDATA_GPUMEMORY	//!< @brief ubNf[^i[郁[I @details 萔錾LFGPU[@萔錾iRgjFC[

#pragma warning(disable:4819)		//VC++xh~
#include <d3dx9.h>
#pragma warning(default:4819)

#pragma comment(lib, "d3d9.lib")
#pragma comment(lib, "d3dx9.lib")

#if GRAPHIC_ENGINE == 0
 #define GRAPHICS_CORE "DirectX 9.0"				//!< o[W\p
#else
 #define GRAPHICS_CORE "DirectX 9.0 (Shader)"		//!< o[W\p
 #define HLSLFILE 201								//!< \[XHLSLt@C
#endif

#elif GRAPHIC_ENGINE == 8

//#define ENABLE_OPENGL_LIBJPEGPNG		//!< OpenGLɂlibjpegElibpnggp

#include <ctype.h>
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")

#ifdef ENABLE_OPENGL_LIBJPEGPNG
 #include "lib/libjpeg/jpeglib.h"
 #include "lib/zlib/zlib.h"
 #include "lib/libpng/png.h"

 //libjpeg.lib, zlib.lib, libpng.lib ͎OŗpӂKv܂B
 #pragma comment(lib, "lib/libjpeg/libjpeg.lib")
 #pragma comment(lib, "lib/zlib/zlib.lib")
 #pragma comment(lib, "lib/libpng/libpng.lib")

 //#pragma comment(lib, "legacy_stdio_definitions.lib")

 #pragma comment(linker, "/NODEFAULTLIB:libcmt.lib")
 #pragma comment(linker, "/NODEFAULTLIB:libcpmt.lib")
#endif

#define GRAPHICS_CORE "OpenGL 1.1"		//!< o[W\p

#endif	//GRAPHIC_ENGINE

#if (GRAPHIC_ENGINE == 0)||(GRAPHIC_ENGINE == 1)

//! 3D|S`p\
struct VERTEXTXTA
{
	D3DXVECTOR3 position;	//!< The position
	DWORD       color;		//!< The color 
	FLOAT       tu;			//!< The texture coordinates
	FLOAT       tv;			//!< The texture coordinates
};

//! 2D|S`p\
struct TLVERTX
{
	FLOAT    x;		//!< position
	FLOAT    y;		//!< position
	FLOAT    z;		//!< position
	FLOAT    rhw;	//!< vector
	D3DCOLOR color;	//!< color
	FLOAT    tu;	//!< texture coordinates
	FLOAT    tv;	//!< texture coordinates
};

#elif GRAPHIC_ENGINE == 8

//! ff[^̒_i[\
struct MODELVDATA
{
	float x;	//!< position
	float y;	//!< position
	float z;	//!< position
	float u;	//!< texture coordinates
	float v;	//!< texture coordinates
};

//! ff[^\
struct MODELDATA
{
	bool useflag;			//!< LtO
	int polygons;			//!< |S
	float *VertexAry;		//!< _i[z
	float *ColorAry;		//!< Fi[z
	float *ColorGrayAry;	//!< Fi[ziÂj
	float *TexCoordAry;		//!< eNX`Wi[z
};

//! eNX`\
struct TEXTUREDATA
{
	bool useflag;			//!< LtO
	int width;				//!< 
	int height;				//!< 
	unsigned char *data;	//!< f[^
};

#endif	//GRAPHIC_ENGINE


//! @brief ʕ`sNX
//! @details ʂ̕`@\₻ɒڊ֘A鏈s܂B
//! @details ̓IɁA3D`E2D`Eft@CeNX`Ǘ@s@\܂B
class D3DGraphics
{

#if (GRAPHIC_ENGINE == 0)||(GRAPHIC_ENGINE == 1)

	LPDIRECT3D9 pD3D;					//!< DIRECT3D9̃|C^
	LPDIRECT3DDEVICE9 pd3dDevice;		//!< DIRECT3DDEVICE9̃|C^
	float aspect;						//!< ʂ̃AXyNg
	bool fullscreenflag;				//!< tXN[\
	int LanguageMode;					//!< I
	LPD3DXMESH pmesh[MAX_MODEL];				//!< iXt@CpjD3DXMESH̃|C^
	DWORD nummaterials[MAX_MODEL];				//!< iXt@Cpj}eA
	LPDIRECT3DTEXTURE9 ptextures[MAX_TEXTURE];	//!< eNX`i[

#if GRAPHIC_ENGINE == 1
	LPDIRECT3DVERTEXSHADER9	hVertexShader;			//!< _VF[_[
	LPD3DXCONSTANTTABLE hVSConstantTable;			//!< _VF[_[̒萔e[u
	D3DXHANDLE hVSWorldVertexPos;					//!< _VF[_[̕ϊs
	D3DXHANDLE hVSWorldViewPos;						//!< _VF[_[̕ϊs
	D3DXHANDLE hVSWorldViewProj;					//!< _VF[_[̕ϊs
	D3DXHANDLE hVSDiffuse;							//!< _VF[_[̃fBt[YF
	LPDIRECT3DPIXELSHADER9 pPixelShader;			//!< sNZVF[_[
	LPD3DXCONSTANTTABLE pPSConstantTable;			//!< sNZVF[_[̒萔e[u
	D3DXHANDLE hPSEnableTexture;					//!< sNZVF[_[̃eNX`tO
	D3DXMATRIX VSWorldPosMatrix;					//!< _VF[_[ɗ^ϊs
	D3DXMATRIX VSViewPosMatrix;						//!< _VF[_[ɗ^ϊs
	D3DXMATRIX VSViewProjMatrix;					//!< _VF[_[ɗ^ϊs
#endif

	class BlockDataInterface* blockdata;		//!< ǂݍ񂾃ubNf[^i[NXւ̃|C^
	int bs;										//!< ubN
	int mapTextureID[TOTAL_BLOCKTEXTURE];		//!< eNX`ԍ
#ifdef BLOCKDATA_GPUMEMORY
	LPDIRECT3DVERTEXBUFFER9 g_pVB;				//!< _iGPUǗj
#else
	VERTEXTXTA g_pVertices[MAX_BLOCKS][6][4];	//!< _iCPUǗj
#endif

	float HUD_myweapon_x[TOTAL_HAVEWEAPON];		//!< HUD̕` XW
	float HUD_myweapon_y[TOTAL_HAVEWEAPON];		//!< HUD̕` YW
	float HUD_myweapon_z[TOTAL_HAVEWEAPON];		//!< HUD̕` ZW

	bool StartRenderFlag;			//!< StartRender()֐ s\tO
	bool EnableFogFlag;				//!< tHOgp\tO

	LPD3DXSPRITE ptextsprite;			//!< 2DeNX`XvCg
	LPD3DXFONT pxmsfont;				//!< VXetHg
	LPD3DXFONT pxmssmallfont;			//!< VXetHgij
	char TextureFontFname[_MAX_PATH];	//!< eNX`tHg̃t@C
	int TextureFont;					//!< eNX`tHg̃eNX`ID

	int InitSubset();
	void CleanupD3Dresource();
	void Start2DMSFontTextRender();
	void End2DMSFontTextRender();
	void Start2DRender();
	void End2DRender();

#elif GRAPHIC_ENGINE == 8

	HWND hWnd;				//!< EBhEnh
	HGLRC hGLRC;			//!< OpenGL̃ReLXg
	int width;				//!< 
	int height;				//!< 
	bool fullscreenflag;	//!< tXN[\
	int LanguageMode;		//!< I
	PAINTSTRUCT Paint_ps;					//!< BeginPaint()֐EndPaint()֐p
	MODELDATA pmodel[MAX_MODEL];			//!< ff[^i[
	TEXTUREDATA ptextures[MAX_TEXTURE];		//!< eNX`i[
	GLuint textureobjname[MAX_TEXTURE];		//!< eNX`IuWFNg
	HFONT SystemFont;				//!< VXetHgp̘_tHg
	HFONT SystemSmallFont;			//!< VXetHgp̘_tHgij
	WCHAR *now_SystemFontUStr;		//!< ݕ\̃VXetHgɂ镶iUnicodej
	GLuint SystemFontListIdx;		//!< VXetHg̃fBXvCXg
	int SystemFontListIdxSize;		//!< VXetHg̃fBXvCXg̃TCY
	float SystemFont_posz;			//!< VXetHgZW
	int now_textureid;		//!< ݐݒ蒆̃eNX`ԍ

	float camera_x;			//!< JW
	float camera_y;			//!< JW
	float camera_z;			//!< JW
	float camera_rx;		//!< J]px
	float camera_ry;		//!< J]px
	float viewangle;		//!< J̎p

	class BlockDataInterface* blockdata;		//!< ǂݍ񂾃ubNf[^i[NXւ̃|C^
	int bs;										//!< ubN
	int mapTextureID[TOTAL_BLOCKTEXTURE];		//!< eNX`ԍ

	char TextureFontFname[_MAX_PATH];	//!< eNX`tHg̃t@C
	int TextureFont;				//!< eNX`tHg̃eNX`ID

	float HUD_myweapon_x[TOTAL_HAVEWEAPON];		//!< HUD_A̕` XW
	float HUD_myweapon_y[TOTAL_HAVEWEAPON];		//!< HUD_A̕` YW
	float HUD_myweapon_z[TOTAL_HAVEWEAPON];		//!< HUD_A̕` ZW

#ifdef ENABLE_OPENGL_LIBJPEGPNG
	jpeg_decompress_struct cinfo;	//!< libjpeg
	jpeg_error_mgr jerr;			//!< libjpeg
#endif

	void CleanupD3Dresource();
	int CheckTextureFileExtension(const char* filename, int nowformat);
	int CheckTextureFileTypeFlag(const char* filename, int nowformat);
	bool LoadBMPTexture(const char* filename, bool BlackTransparent, TEXTUREDATA *ptexture);
	bool LoadDDSTexture(const char* filename, bool BlackTransparent, TEXTUREDATA *ptexture);
	bool LoadJPEGTexture(const char* filename, bool BlackTransparent, TEXTUREDATA *ptexture);
	bool LoadPNGTexture(const char* filename, bool BlackTransparent, TEXTUREDATA *ptexture);
	void SetTexture(int TextureID);
	int StrMaxLineLen(const char *str);
	void Start2DRender();
	void End2DRender();

#endif	//GRAPHIC_ENGINE

#ifdef ENABLE_DEBUGCONSOLE
	unsigned char DebugFontData[96][16];	//!< fobNptHgf[^i[z
	int TextureDebugFont;					//!< fobNptHg̃eNX`ID
	void InitDebugFontData();
	bool LoadDebugFontTexture();
#endif

public:
	D3DGraphics();
	~D3DGraphics();
	void SetFullScreenFlag(bool fullscreen);
	bool GetFullScreenFlag();
	void SetlanguageMode(int mode);
	int GetlanguageMode();
	int InitD3D(WindowControl *WindowCtrl, const char *TextureFontFilename, bool fullscreen, int language);
	int ResetD3D(WindowControl *WindowCtrl);
	void DestroyD3D();
	int LoadModel(const char* filename);
	int MorphingModel(int idA, int idB);
	int GetTotalModels();
	void CleanupModel(int id);
	int LoadTexture(const char* filename, bool texturefont, bool BlackTransparent);
	int GetTextureSize(int id, int *width, int *height);
	int GetTotalTextures();
	void CleanupTexture(int id);
	int StartRender();
	bool EndRender();
	void ResetZbuffer();
	void ResetWorldTransform();
	void SetWorldTransform(float x, float y, float z, float rx, float ry, float size);
	void SetWorldTransform(float x, float y, float z, float rx, float ry1, float ry2, float size);
	void SetWorldTransformEffect(float x, float y, float z, float rx, float ry, float rt, float size);
	void SetWorldTransformHumanWeapon(float x, float y, float z, float mx, float my, float mz, float rx, float ry, float size);
	void SetWorldTransformPlayerWeapon(bool rotation, float camera_rx, float camera_ry, float rx, float size);
	void GetWorldTransformPos(float *x, float *y, float *z);
	void SetFog(bool enablefog, int skynumber);
	void SetCamera(float camera_x, float camera_y, float camera_z, float camera_rx, float camera_ry, float viewangle);
	void LoadMapdata(class BlockDataInterface* in_blockdata, const char *directory);
	void RenderMapdata(bool wireframe);
	int GetMapTextureID(int id);
	void CleanupMapdata();
	void RenderModel(int id_model, int id_texture, bool darkflag, bool nomodel);
	void RenderBoard(int id_texture, float alpha, bool nomodel);
	void StartEffectRender();
	void EndEffectRender();
	void ScreenBrightness(int Width, int Height, int Brightness);
	void RenderCenterline();
	void Renderline(float x1, float y1, float z1, float x2, float y2, float z2, int color);
	void Draw2DMSFontText(int x, int y, const char *str, int color);
	void Draw2DMSFontTextScaling(int x, int y, const char *str, int color);
	void Draw2DMSFontTextCenter(int x, int y, int w, int h, const char *str, int color);
	void Draw2DMSFontTextCenterScaling(int x, int y, int w, int h, const char *str, int color);
	void Draw2DMSSmallFontText(int x, int y, const char *str, int color);
	void GetFontTextSize(const char *str, int base_w, int base_h, int limitlen, int *w, int *h);
	void Draw2DTextureFontText(int x, int y, const char *str, int color, int fontwidth, int fontheight);
	void Draw2DTextureFontTextScaling(int x, int y, const char *str, int color, int fontwidth, int fontheight);
	void Draw2DTextureFontTextCenter(int x, int y, const char *str, int color, int fontwidth, int fontheight);
	void Draw2DTextureFontTextCenterScaling(int x, int y, const char *str, int color, int fontwidth, int fontheight);
#ifdef ENABLE_DEBUGCONSOLE
	void Draw2DTextureDebugFontText(int x, int y, const char *str, int color);
#endif
	void Draw2DLine(int x1, int y1, int x2, int y2, int color);
	void Draw2DCycle(int x, int y, int r, int color);
	void Draw2DBox(int x1, int y1, int x2, int y2, int color);
	void Draw2DBoxScaling(int x1, int y1, int x2, int y2, int color);
	void Draw2DTexture(int x, int y, int id, int width, int height, float alpha);
	void Draw2DTextureScaling(int x, int y, int id, int width, int height, float alpha);
	bool SaveScreenShot(const char *fname);
	int GetColorCode(float red, float green, float blue, float alpha);
};

#endif