//! @file event.cpp
//! @brief EventControlNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "event.h"

//! @brief RXgN^
EventControl::EventControl(PointDataInterface *in_Point, ObjectManager *in_ObjMgr)
{
	Point = in_Point;
	ObjMgr = in_ObjMgr;
	nextp4 = 0;
	waitcnt = 0;
}

//! @brief fBXgN^
EventControl::~EventControl()
{}

//! @brief ΏۃNXݒ
//! @param in_Point |Cgf[^ǗNX
//! @param in_ObjMgr IuWFNgǗNX
//! @attention ̊֐ŐݒsȂƁANX̂@\܂B
void EventControl::SetClass(PointDataInterface *in_Point, ObjectManager *in_ObjMgr)
{
	Point = in_Point;
	ObjMgr = in_ObjMgr;
}

//! @brief Zbg
//! @param EntryP4 CxgJnFԍ@i-100A-110A-120@Ȃǁj
void EventControl::Reset(signed char EntryP4)
{
	nextp4 = EntryP4;
	waitcnt = 0;
}

//! @brief ɏFԍ
//! @return P4FFԍ
signed char EventControl::GetNextP4()
{
	return nextp4;
}

//! @brief Ώېl̎S
//! @param targetP4 ^[Qbg̔Fԍ
//! @param reverse ]i艻j
//! @return trueF̃Cxg֐iށ@falseF֐i܂Ȃ
//! @attention Ώېl݂ȂꍇAfalseɂȂ܂B
bool EventControl::CheckDead(signed char targetP4, bool reverse)
{
	human* thuman;

	thuman = ObjMgr->SearchHuman(targetP4);
	if( thuman == NULL ){ return false; }

	if( reverse == false ){
		if( thuman->GetDeadFlag() == false ){ return false; }
	}
	else{
		if( thuman->GetDeadFlag() == true ){ return false; }
	}
	return true;
}

//! @brief Ώېl̓
//! @param pos_x 肷XW
//! @param pos_y 肷YW
//! @param pos_z 肷ZW
//! @param dist_r 肷鋗iaj
//! @param targetP4 ^[Qbg̔Fԍ
//! @param reverse ]i艻j
//! @return trueF̃Cxg֐iށ@falseF֐i܂Ȃ
//! @attention Ώېl݂ȂꍇAfalseɂȂ܂B
bool EventControl::CheckArrival(float pos_x, float pos_y, float pos_z, float dist_r, signed char targetP4, bool reverse)
{
	human* thuman;
	float hx, hy, hz;
	float x, y, z;

	thuman = ObjMgr->SearchHuman(targetP4);
	if( thuman == NULL ){ return false; }
	thuman->GetPosData(&hx, &hy, &hz, NULL);
	x = hx - pos_x;
	y = hy - pos_y;
	z = hz - pos_z;

	if( reverse == false ){
		if( sqrtf(x*x + y*y+ + z*z) > dist_r ){ return false; }
	}
	else{
		if( sqrtf(x*x + y*y+ + z*z) < dist_r ){ return false; }
	}
	return true;
}

//! @brief Ώېl̎w蕐폊L
//! @param WeaponID ̎ޔԍ
//! @param targetP4 ^[Qbg̔Fԍ
//! @param reverse ]iL艻j
//! @return trueF̃Cxg֐iށ@falseF֐i܂Ȃ
//! @attention Ώېl݂ȂꍇAfalseɂȂ܂B
bool EventControl::CheckHaveWeapon(int WeaponID, signed char targetP4, bool reverse)
{
	human* thuman;
	int selectweapon;
	weapon *out_weapon[TOTAL_HAVEWEAPON];
	int now_weaponid;
	bool flag = false;			//false:LAtrue:L

	thuman = ObjMgr->SearchHuman(targetP4);
	if( thuman == NULL ){ return false; }

	//L镐IuWFNgSĎ擾
	thuman->GetWeapon(&selectweapon, out_weapon, NULL, NULL);

	//SĒׂ
	for(int i=0; i<TOTAL_HAVEWEAPON; i++){
		if( out_weapon[i] != NULL ){

			//̎ޔԍ擾AꂪΏۂ̕킩ǂB
			out_weapon[i]->GetParamData(&now_weaponid, NULL, NULL);
			if( now_weaponid == WeaponID ){
				flag = true;
			}

		}
	}

	if( reverse == false ){
		if( flag == false ){ return false; }
	}
	else{
		if( flag == true ){ return false; }
	}
	return true;
}

//! @brief ΏۈړpẌړ[h
//! @param targetP4 ^[Qbg̔Fԍ
//! @param newmode ړ[h
//! @return Ftrue@sFfalse
bool EventControl::SetMovePathMode(signed char targetP4, int newmode)
{
	pointdata pathdata;
	int pid;

	if( Point->SearchPointdata(&pid, 0x08, 0, 0, 0, targetP4, 0) > 0 ){

		//ΏۂAIpXȂ΁AIɃp[^
		Point->Getdata(&pathdata, pid);
		if( (pathdata.p1 == 3)||(pathdata.p1 == 8) ){
			pathdata.p2 = (signed char)newmode;
			Point->SetParam(pid, pathdata.p1, pathdata.p2, pathdata.p3, pathdata.p4);
			return true;
		}

	}
	return false;
}

//! @brief Ώېl̃`[ԍύX
//! @param targetP4 ^[Qbg̔Fԍ
//! @param TeamID `[ԍ
//! @return Ftrue@sFfalse
bool EventControl::SetTeamID(signed char targetP4, int TeamID)
{
	human* thuman;

	thuman = ObjMgr->SearchHuman(targetP4);
	if( thuman == NULL ){ return false; }

	thuman->SetTeamID(TeamID);
	return true;
}

//! @brief Ώۏ̔j󔻒
//! @param targetP4 ^[Qbg̔Fԍ
//! @param reverse ]ij󔻒艻j
//! @return trueF̃Cxg֐iށ@falseF֐i܂Ȃ
//! @attention Ώۏ݂ȂꍇAjς݂Ƃď܂B
bool EventControl::CheckBreakSmallObject(signed char targetP4, bool reverse)
{
	smallobject* tsmallobject;
	bool flag = true;			//false:jAtrue:jςor݂Ȃ

	tsmallobject = ObjMgr->SearchSmallobject(targetP4);
	if( tsmallobject != NULL ){
		if( tsmallobject->GetEnableFlag() == true ){ flag = false; }
	}

	if( reverse == false ){
		if( flag == false ){ return false; }
	}
	else{
		if( flag == true ){ return false; }
	}
	return true;
}

//! @brief ԑ҂ibPʁj
//! @param sec b
//! @return trueF̃Cxg֐iށ@falseF֐i܂Ȃ
bool EventControl::WaitSec(int sec)
{
	if( ((int)GAMEFPS * sec) > waitcnt ){
		waitcnt += 1;
		return false;
	}
	waitcnt = 0;
	return true;
}

//! @brief bZ[W\
//! @param SetID bZ[Wԍ
//! @param MessageID MessageID̃|C^
//! @param SetMessageID SetMessageID̃|C^
//! @attention ͈͊ÕbZ[Wԍw肳ďꍇAVȃbZ[Ww肳ꂽ̂Ƃď܂B
void EventControl::SetMessage(int SetID, int *MessageID, bool *SetMessageID)
{
	if( (0 <= SetID)&&(SetID < MAX_POINTMESSAGES) ){
		*MessageID = SetID;
	}
	*SetMessageID = true;
}

//! @brief s
//! @param SkipFlag Cxg^XÑXLbvtO
//! @param Param Cxg̃p[^[󂯓n\̂̃|C^
//! @return sXebv
//! @attention nꂽp[^[i\́jɕύXȂꍇAnꂽp[^[͑삳܂B
//! @attention \̂SetMessageID ́AbZ[WCxgsꂽꍇ true ɂȂ܂B<b>O񂩂ύXꂽƂ͌܂B</b>
int EventControl::ProcessEventPoint(bool SkipFlag, EventParameter *Param)
{
	if( Param == NULL ){ return 0; }

	pointdata data;
	int cnt = 0;

	for(int i=0; i<TOTAL_EVENTFRAMESTEP; i++){
		cnt = i;

		//̃|CgT
		if( Point->SearchPointdata(&data, 0x08, 0, 0, 0, nextp4, 0) == 0 ){ return cnt; }

		//ȔԍȂ珈Ȃ
		if( (data.p1 < 10)||(19 < data.p1) ){
#ifdef ENABLE_CHECKOPENXOPSEVENT
			if( data.p1 != 29 ){ return cnt; }
#else
			return cnt;
#endif
		}

		//[v1ڂŃXLbvtOLȂ΁ACxg֐iށB
		if( (cnt == 0)&&(SkipFlag == true) ){
			nextp4 = data.p3;
			continue;
		}

		switch(data.p1){
			case 10:	//CB
				Param->endcnt += 1;
				Param->complete = true;
				return cnt;

			case 11:	//Cs
				Param->endcnt += 1;
				Param->complete = false;
				return cnt;

			case 12:	//S҂
				if( CheckDead(data.p2, false) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 13:	//҂
				if( CheckArrival(data.x, data.y, data.z, DISTANCE_CHECKPOINT, data.p2, false) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 14:	//ɕύX
				SetMovePathMode(data.p2, 0);
				nextp4 = data.p3;
				break;

			case 15:	//j҂
				if( CheckBreakSmallObject(data.p2, false) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 16:	//P[X҂
				if( CheckArrival(data.x, data.y, data.z, DISTANCE_CHECKPOINT, data.p2, false) == false ){ return cnt; }
				if( CheckHaveWeapon(ID_WEAPON_CASE, data.p2, false) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 17:	//ԑ҂
				if( WaitSec((unsigned char)data.p2) == false ){ return cnt; }
				nextp4 = data.p3;
				break;

			case 18:	//bZ[W
				SetMessage((unsigned char)data.p2, &(Param->MessageID), &(Param->SetMessageID));
				nextp4 = data.p3;
				break;

			case 19:	//`[ύX
				SetTeamID(data.p2, 0);
				nextp4 = data.p3;
				break;

#ifdef ENABLE_CHECKOPENXOPSEVENT
			case 29:	//OpenXOPS
				if( data.p2 != 0 ){ return cnt; }
				nextp4 = data.p3;
				break;
#endif

			//VȃCxg|CgǉꍇAɏB
			//@ ޔԍ̋ 
			//@ {switchOɂAi͈̓`FbNj邱ƁB
		}
	}
	return cnt;
}